<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Verificar que se subió un archivo sin errores -->
    if (isset($_FILES['archivo']) && $_FILES['archivo']['error'] === UPLOAD_ERR_OK) {
        $archivoTmp = $_FILES['archivo']['tmp_name'];
        $nombreArchivo = basename($_FILES['archivo']['name']);
        $carpetaDestino = 'uploads/';

        // Validar que es un archivo XML
        $extension = strtolower(pathinfo($nombreArchivo, PATHINFO_EXTENSION));
        if ($extension !== 'xml') {
            die("Error: Solo se permiten archivos XML.");
        }

        // Crear carpeta si no existe
        if (!is_dir($carpetaDestino)) {
            mkdir($carpetaDestino, 0777, true);
        }

        $rutaFinal = $carpetaDestino . $nombreArchivo;

        // Mover el archivo a la carpeta destino
        if (move_uploaded_file($archivoTmp, $rutaFinal)) {
            echo "<h3>Archivo XML subido exitosamente.</h3>";

            // Leer el archivo XML
            $xml = simplexml_load_file($rutaFinal);
;
            if ($xml) 
            {
                echo "<h4>Contenido Completo del XML:</h4>";
                echo "<pre>";
                print_r($xml);
                echo "</pre>";

// Función recursiva para mostrar todas las etiquetas y sus valores
function mostrarTags($elemento, $nivel = 0) {
    
  foreach ($elemento->children() as $tag => $child) 
  {
        // Sangría según el nivel de profundidad//
        echo "<br>".str_repeat("&nbsp;&nbsp;&nbsp;&nbsp;", $nivel);
        // Mostrar nombre del tag//
        echo "<br><strong>&lt;$tag&gt;</strong>";
        //Mostrar atributos si existen//
        $atributos = $child->attributes();
                    
        if (count($atributos)) 
           {
               foreach ($atributos as $attr => $valor) 
                  {
                     echo "<br> <em>($attr=\"$valor\")</em>";
                  }
           }
        // Mostrar contenido si no tiene hijos//
        if (count($child->children()) === 0) 
            {
                $lcDes = htmlspecialchars((string)$child) ;
                switch($tag)
                   {
                      case "estab": 
                           $rests = $lcDes ;
                           break;
                      case "ptoEmi": 
                           $remis = $lcDes ;
                           break;
                      case "secuencial": 
                           $rsecu = $lcDes ;
                           break;
                      case "claveAcceso": 
                           $clave = $lcDes ;
                           break;
                      case "numDocSustento": 
                           $factura = $lcDes ;
                           $fests = substr($factura,0,3) ;
                           $femis = substr($factura,3,3) ;
                           $fsecu = substr($factura,-9) ;
                           echo "Factura => ".$fests."-".$femis."-".$fsecu ;
                           break;
                      case "ruc":
                           $idCliente = $lcDes ;
                           break;
                      case "identificacionSujetoRetenido":
                           $idEmpresa = $lcDes ;
                           break;
                      case "fechaEmisionDocSustento":
                           $fecha = $lcDes ;
                           break;
                      case "codDocSustento":
                           $TiDo = $lcDes ;
                           break;

                    
                   }
                echo ": " . htmlspecialchars((string)$child) . "<br>";
            }
        else 
            {
               mostrarTags($child, $nivel + 1); // Llamada recursiva
            }
    }
   //echo "Retencion => ".$rests."-".$remis."-".$rsecu ; 
}

// Mostrar el contenido del XML
echo "<h3>Contenido del archivo XML:</h3>";
//mostrarTags($xml);

// Obtener el contenido CDATA de <comprobante>
$comprobanteCDATA = (string)$xml->comprobante;

// Cargar el XML embebido dentro de <comprobante>
$comprobanteXML = simplexml_load_string($comprobanteCDATA);

if ($comprobanteXML) {
    echo "<h3>📄 XML Embebido en &lt;comprobante&gt;:</h3>";
    mostrarTags($comprobanteXML);
} else {
    echo "<p>⚠️ No se pudo cargar el XML dentro de &lt;comprobante&gt;</p>";
}

            }
            else {
                echo "Error: No se pudo leer el archivo XML.";
            }
        } else {
            echo "Error al mover el archivo.";
        }
    } else {
        echo "Error al subir el archivo.";
    }
} else {
    echo "Acceso no permitido.";
}
?>