<script type="text/javascript" src="../js/js-Public-1.0.js"></script>
<?php
// Procesos y Funciones Generales

// Cabecera de Pantalla de Mantenimiento
function prCabeceraMnt($titulo, $linkPrg, $dbTable, $preField, $Campos, $Cabecera, $Condi, $sqlDato )
{
  // $titulo = Titulo de la Pagina
  // $linkPrg = Enlace a la pagina de datos
  // $dbTable = Nombre de la tabla
  // $preField = Prefijo de la tabla
  // $Campos = Campos a Mostrar en la pagina
  // $Cabecera = De las columna a mostrar
  // $Condi = condicion de Busqueda
  // $sqlDato = Sentencia Sql para mostrar informacion 
  
   include("../coneccion/DBConexion.php");
   
   prCabecera();
  
   $titCaption = $titulo;
   $pageLink   = $linkPrg;
   $nomTabla   = $dbTable;
   $campo      = $preField;
   $lcCadena   = $Cabecera;
   $lcNombre   = '';
   $lnVez      = 1 ;

     if (empty($Condi))
         $Condicion  = "" ;
     else
         $Condicion  = " where ". $Condi;
       

   for ($i=0; $i<=strlen($lcCadena); $i++)
       {
          $lcCara = substr($lcCadena,$i,1);
          if ($lcCara == ',' or $i==strlen($lcCadena))
             {
               if ($lnVez == 1)
                   $caCodigo = $lcNombre;
               else
                   $caDescri  = $lcNombre;
               $lcNombre = '';
               $lnVez = $lnVez+1;
             }
          else
             $lcNombre = $lcNombre.$lcCara;
       }
   $lcCadena   = $Campos;
   $lnVez      = 1 ;
   for ($i=0; $i<=strlen($lcCadena); $i++)
       {
          $lcCara = substr($lcCadena,$i,1);
          if ($lcCara == ',' or $i==strlen($lcCadena))
             {
               if ($lnVez == 1)
                   $dbCodigo = $lcNombre;
               else
                   $dbDescri  = trim($lcNombre);
               $lcNombre = '';
               $lnVez = $lnVez+1;
             }
          else
             $lcNombre = $lcNombre.$lcCara;
       }

   echo '<table  class="TablaGeneral" width = "45%"  border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
   echo '<caption align="top"><h1>'.$titCaption.'</h1></caption>';
   echo '<thead>';
   
   echo '<tr>';
   echo '<td colspan="4" align="right">';
   echo '<a title="Nuevo Registro" href="'.$pageLink.'" target="_blank" > <img src="../Graficos/nuevo.bmp" width=30 height=30 />';
   echo '</td>';
   echo '</tr>';
   echo '<tr height="5">';
   echo '<th width="80">'.$caCodigo.'</th>';
   echo '<th>'.$caDescri.'</th>';
  
   if ($nomTabla == "usuario")
      {
         echo '<th>Caduca</th>';
      }
   else
        echo '<th>Estado</th>';
   echo '</thead>';

   // Comprobar si existe registro
   if (empty($sqlDato))
      $lcSql ='select * from '.$nomTabla.$Condicion.' order by '.$dbCodigo ;
   else
      $lcSql = $sqlDato ;
    
   $query = $mySql->query($lcSql);   
   while($row_sql=mysqli_fetch_assoc($query))
    {
       $codigo = $row_sql[$dbCodigo] ;
       $descri = $row_sql[$dbDescri];
       if ($nomTabla == "usuario")
          $tipo = obtenerFechaEnLetra($row_sql[$campo."caduca"], 2);
           
       else  
         $tipo   = $row_sql[$campo."codestado"];
         
       echo "<tr>";
       echo "<td align='center'>" ;
       echo '<a href="'.$pageLink.'?keyCta='.$codigo.'" target="_blank">'.$codigo;
       echo "</td>";
       echo "<td>" ;
       echo $descri ;
       echo "</td>";
       echo "<td align='center'>" ;
       echo $tipo ;
       echo "</td>";

       echo "</tr>";
    }
    echo "</table>";
}

function prCabecera()
{
  include("../coneccion/DBConexion.php");

  if ($_SESSION['user_estado']==1)
     {
       $lcSql ='select * from empresa' ;
       $query = $mySql->query($lcSql);
       while($row_sql=mysqli_fetch_assoc($query))
            {
              $logo = $row_sql['empr_logo'] ;
              $abrevia = $row_sql['empr_abrevia'];
            }
       echo '<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" style="oveflow:auto;">';
       echo '  <tr>';
       echo '    <td><input type="image" name="imgLogo" src="'.$logo.'" width="45" ></td>';
       echo '    <td align="right"><h1>'.$abrevia.'</h1></td>';
       echo '    <td align="center"><h3>SISTEMA EXPERTODB V. 1.0</h3></td>';
       echo '  </tr>';
       echo '</table>';
     }
  else
     {
         echo "<script>";
         echo "fnRedireccion();";
         echo "</script>";  ;
     }
}

function fnLoadLst($dbConn, $dbTabla, $lstName, $colCodigo, $colNombre, $colCond, $conProv  )
{
  include("../coneccion/DBConexion.php");
  
  if (empty($colCond))
      $colCond = "";
  else
      $colCond = "Where ".$colCond ;

  $lcSql = "SELECT * FROM ".$dbTabla." ".$colCond." order by ".$colCodigo;
  $query = $dbConn->query ($lcSql);
  
  echo '<datalist id="'.$lstName.'">';
  while ($row_sql = mysqli_fetch_assoc($query))
    {
      if ($conProv=='S')
         {
           $cambia = $row_sql['cppr_cambia'];
           if ($cambia == 'S')
              $colNombre = 'cppr_beneficiario';
         }
      echo '<option value="'.$row_sql[$colCodigo].'">'.$row_sql[$colNombre].'</option>';
    }
  echo "</datalist>";
}

function fnLoadDesc($dbConn, $dbTabla, $colCodigo, $colNombre, $colCond  )
{
  include("../coneccion/DBConexion.php");

  $Resul = '';

  $lcSql = "SELECT * FROM ".$dbTabla." Where ".$colCodigo." = '".$colCond."' order by ".$colCodigo;
  $query = $dbConn->query ($lcSql);
  while ($row_sql = mysqli_fetch_assoc($query))
    {
      $Resul = $row_sql[$colNombre];
    }

    Return $Resul;

}

// Detalle de Cuentas en Ingreso de
// Comprobante Contable
function prDetalleCta($lsecuen, $lnMues)
{
  include("../coneccion/DBConexion.php");
  if ($lnMues == 1 or $lnMues == 2 )
     {
       // Temporal de Cuentas
       $lcSql   ='select sum(debito) debito, sum(credito) credito from movicuenta where transac <> "DD" and secuencia = '.$lsecuen;
       $row_sum = $mySql->query($lcSql);
       $Sum_Debi  = 0.00 ;
       $Sum_Credi = 0.00 ;
       while($row_total=mysqli_fetch_assoc($row_sum))
        {
            $Sum_Debi  = $row_total['debito']  ;
            $Sum_Credi = $row_total['credito'] ;
        }
       echo '<table class="TablaGeneral" width = "60%"  border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
       echo '<caption align="top"><h2>Movimiento Contable</h2></caption>' ;

       echo "<thead>";
       echo "<tr>";
       echo "<th>Cuenta</th>";
       echo "<th>Descripción</th>";
       echo "<th>Débito</th>";
       echo "<th>Crédito</th>";
       echo "<th>Dpto</th>";
       echo "<th>Area</th>";
       echo "<th>Detalle</th>";
    
       if ($lnMues == 1)
          echo "<th>Acción</th>";
    
       echo "</tr>";
       echo "</thead>";
       
       echo "<tbody style='max-height:100px; overflow:auto'>";

       $lcSql   ='select * from movicuenta where transac <> "DD" and secuencia = '.$lsecuen;
       $row_res = $mySql->query($lcSql);
       while($row_deta=mysqli_fetch_assoc($row_res))
        {

            $cuenta = $row_deta['cuenta']  ;
            $descri = $row_deta['descrip'] ;
            $debi   = $row_deta['debito']  ;
            $credi  = $row_deta['credito'] ;
            $dpto   = $row_deta['dpto']    ;
            $area   = $row_deta['area']    ;
            $glosa  = $row_deta['glosa']   ;
            $orden  = $row_deta['orden']   ;
            $Proceso = 2 ;

            echo "<tr>";
            echo "<td style='font-size:12px;'>".$cuenta."</td>";
            echo "<td style='font-size:12px;'>".$descri."</td>";
            echo "<td style='font-size:12px;' align = 'right'>".number_format($debi,2)."</td>";
            echo "<td style='font-size:12px;' align = 'right'>".number_format($credi,2)."</td>";
            echo "<td style='font-size:10px;'>".$dpto."</td>";
            echo "<td style='font-size:10px;'>".$area."</td>";
            echo "<td style='font-size:10px;'>".$glosa."</td>";
            if ($lnMues == 1)
                echo "<td align = 'center'><input type='image' name='Eliminar' src='../Graficos/elimina.bmp' width='15' onclick='fnEliminaDeta(".$orden.",".$lsecuen.",".$Proceso.");'></td>";

            echo "</tr>";
        }
      echo "</tbody>";
      echo "<tfoot>";

       echo "<tr>";
       echo "<th></th>";
       echo "<th align = 'center'><B>TOTAL DIARIO</B></td>";
       echo "<th align = 'right'><B><H4>".number_format($Sum_Debi,2)."</H4></B></th>";
       echo "<th align = 'right'><B><H4>".number_format($Sum_Credi,2)."</H4></B></th>";
       echo "<th></th>";
       echo "<th></th>";
       echo "<th></th>";
    
       if ($lnMues == 1)
          echo "<th></th>";
    
       echo "</tr>"    ;
       echo "</tfoot>"  ;
       echo '</table>';

     }
}

// Detalle de Cuentas en Ingreso de
// Comprobante Contable
function prDetalleFactura($lsecuen, $lnMues)
{
  include("../coneccion/DBConexion.php");
  if ($lnMues == 1 )
     {
       // Temporal de Cuentas
       $lcSql   ='select sum(base) total from movicuenta where base > 0 secuencia = '.$lsecuen;
       $row_sum = $mySql->query($lcSql);
       $Sum_Total = 0.00 ;
       while($row_total=mysqli_fetch_assoc($row_sum))
        {
            $Sum_Total  = $row_total['total']  ;
        }
       $Sum_Total = 0 ;
       echo '<table class="TablaGeneral" width = "60%"  border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
       echo "<thead>";
       echo "<tr>";
       echo "<th>Producto</th>";
       echo "<th>Descripción</th>";
       echo "<th>Iva</th>";
       echo "<th>Cant</th>";
       echo "<th>Base</th>";
       echo "<th>Total</th>";
       echo "<th>Detalle</th>";
       echo "<th>Acción</th>";
       echo "</tr>";
       echo "</thead>";
       
       echo "<tbody style='max-height:100px; overflow:auto'>";

       $lcSql   ='select * from movicuenta where secuencia = '.$lsecuen;
       $row_res = $mySql->query($lcSql);
       while($row_deta=mysqli_fetch_assoc($row_res))
        {
            $cuenta = $row_deta['items']  ;
            $descri = $row_deta['descrip'] ;
            $valiva = $row_deta['porcen1']  ;
            $canti  = $row_deta['porcen2'] ;
            $base   = $row_deta['base']    ;
            $glosa  = $row_deta['glosa']   ;
            $orden  = $row_deta['orden']   ;
            $lnBase = $canti * $base ;
            $Sum_Total = $Sum_Total + $lnBase;

            echo "<tr>";
            echo "<td style='font-size:10px;'>".$cuenta."</td>";
            echo "<td style='font-size:10px;'>".$descri."</td>";
            echo "<td style='font-size:10px;' align = 'right'>".number_format($valiva,2)."</td>";
            echo "<td style='font-size:10px;' align = 'right'>".number_format($canti,2)."</td>";
            echo "<td style='font-size:10px;' align = 'right'>".number_format($base,2)."</td>";
            echo "<td style='font-size:10px;' align = 'right'>".number_format($lnBase,2)."</td>";
            echo "<td style='font-size:10px;'>".$glosa."</td>";
            echo "<td align = 'center'><input type='image' name='Eliminar' src='../Graficos/elimina.bmp' width='15' onclick='fnEliminaDeta(".$orden.",".$lsecuen.");'></td>";
            echo "</tr>";
        }
       echo '</table>';

     }
}

// Detalle de Cuentas en Ingreso de
// Comprobante Contable
function fnSecuencia()
{
  include("../coneccion/DBConexion.php");
  $idSecuen = mt_rand(100,900);
  $lcSql = "select * from movicuenta where secuencia = ".$idSecuen ;
  while ($row_cont->num_rows > 0)
   {
    $idSecuen = mt_rand(100,900);
    $lcSql = "select * from movicuenta where secuencia = ".$idSecuen ;
    $row_cont = $mySql->query($lcSql);
   }
  Return $idSecuen;  
}

function fnDptoArea()
{
    include("../coneccion/DBConexion.php");
    $Dpto  = "" ;
    $Area  = "" ;
    $DesDp = "" ;
    $DesAr = "" ;
      
    $lcSql     = "Select empr_dpto, empr_area from empresa" ;
    $row_empre = $mySql->query($lcSql);
    while ($row_empr=mysqli_fetch_assoc($row_empre))
          {
            $Dpto = $row_empr["empr_dpto"];
            $Area = $row_empr["empr_area"];
          }
    $lcSql    = "Select cgdp_descrip from cgdeparta where cgdp_codigo = '".$Dpto."'" ;
    $row_dpto = $mySql->query($lcSql);
    while ($row_desc=mysqli_fetch_assoc($row_dpto))
          {
            $DesDp = $row_desc["cgdp_descrip"];
          }
    $lcSql    = "Select cgar_descrip from cgarea where cgar_codigo = '".$Area."'" ;
    $row_area = $mySql->query($lcSql);
    while ($row_desc=mysqli_fetch_assoc($row_area))
          {
            $DesAr = $row_desc["cgar_descrip"];
          }

    Return array ($Dpto, $Area, $DesDp, $DesAr);
}

// Pasa de Fecha a Caracter
// lFecha = Fecha
// lCad => Posibles valores
// 1 = Formato 99/XXX/9999
// 2 = Formato 99/XXXXXXXXXX/9999
// 3 = Formato 99 de XXXXXXXXXX del 9999
// 4 = Formato XXXXXX 99 de XXXXXXXXXX del 9999
function obtenerFechaEnLetra($lfecha,$lCad, $lmes = '')
{
    $dia  = conocerDiaSemanaFecha($lfecha);
    $num  = date("d", strtotime($lfecha));
    $anno = date("Y", strtotime($lfecha));
    $mes  = array('enero', 'febrero', 'marzo', 'abril', 'mayo', 'junio', 'julio', 'agosto', 'septiembre', 'octubre', 'noviembre', 'diciembre');
    $array = $mes;
    $mes  = $mes[(date('m', strtotime($lfecha))*1)-1];
    $mes  = strtoupper($mes) ;
    $mesc = substr($mes,0,3) ;
    $mesl = $mes ;
    switch($lCad)
    {
      case 1:
          $rfecha = $num.'/'.$mesc.'/'.$anno;      
          break;
      case 2:
          $rfecha = $num.'/'.$mesl.'/'.$anno;      
          break;
      case 3:
          $rfecha = $num.' de '.$mes.' del '.$anno;      
          break;
      case 4:
          $rfecha = $dia.', '.$num.' de '.$mes.' del '.$anno;      
          break;
      case 5:
          $rfecha = ["ENERO", "FEBRERO", "MARZO", "ABRIL", "MAYO", "JUNIO", "JULIO", "AGOSTO", "SEPTIEMBRE", "OCTUBRE", "NOVIEMBRE", "DICIEMBRE"][$lmes-1];
          break;
    }
      
//$mes = ["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"][date("n") - 1];
//echo $mes;  
    return $rfecha;
}

function conocerDiaSemanaFecha($dfecha) 
{
    $dias = array('Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado');
    $dia = $dias[date('w', strtotime($dfecha))];
    return $dia;
}

function fnOperaFecha($lfec, $oper, $dias)
{
  $ldFecha = date('Y-m-d', strtotime($lfec .' '.$oper.' '.$dias.' day'));
  
  return $ldFecha ;
}
  
  
// Detalle de Dinero
function prDetalleDinero($lsecuen)
{
       include("../coneccion/DBConexion.php");

       echo '<table class="TablaGeneral" border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
       echo "<thead>";
       echo "<tr>";
       echo "<th>Forma</th>";
       echo "<th>Descripción</th>";
       echo "<th>Chq-Autor.</th>";
       echo "<th>Entidad</th>";
       echo "<th>Núm.Cta-Reten.</th>";
       echo "<th>Valor</th>";
       echo "<th>Acción</th>";
       echo "</tr>";
       echo "</thead>";
       
       echo "<tbody style='max-height:100px; overflow:auto'>";

       $lcSql     = "select * from movicuenta where transac = 'DD' and secuencia = ".$lsecuen;
       $row_res   = $mySql->query($lcSql);
       $Sum_Total = 0.00 ;
       while($row_deta=mysqli_fetch_assoc($row_res))
        {
            $FormaPago = $row_deta['forma']  ;
            $DesForma  = $row_deta['desforma'] ;
            $Cheque    = $row_deta['cheque']  ;
            $Valor     = $row_deta['base'] ;
            $Entidad   = $row_deta['entidad']    ;
            $Tarjeta   = $row_deta['tarjeta']   ;
            $orden     = $row_deta['orden']   ;
            $lsecuen   = $row_deta['secuencia']   ;
            $Sum_Total = $Sum_Total + $Valor;
            $Proceso   = 1 ;

            echo "<tr>";
            echo "<td style='font-size:11px;'>".$FormaPago."</td>";
            echo "<td style='font-size:11px;'>".$DesForma."</td>";
            echo "<td style='font-size:11px;'>".$Cheque."</td>";
            echo "<td style='font-size:11px;'>".$Entidad."</td>";
            echo "<td style='font-size:11px;'>".$Tarjeta."</td>";
            echo "<td style='font-size:11px;' align = 'right'>".number_format($Valor,2)."</td>";
            echo "<td align = 'center'><input type='image' name='Eliminar' src='../Graficos/elimina.bmp' width='15' onclick='fnEliminaDeta(".$orden.",".$lsecuen.",".$Proceso.");fnTotalDinero(".$lsecuen.");'></td>";
            echo "</tr>";
        }
       echo "</tbody>";
       echo '</table>';
  Return;
}

// Identacion Cuenta del Catalago
function fnIdentaBalance($lCuenta, $lTipo)
  {
    $lLong    = strlen($lCuenta);
    $lcCelda = '';

    if ($lTipo == 1)
       {
        switch ($lLong)
             {
                case 1:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;";
                     break;
                case 3:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
                case 5:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
                case 7:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
                case 8:
                case 9:
                case 10:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
             }
       }
    else
         {
        switch ($lLong)
             {
                case 2:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;";
                     break;
                case 4:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
                case 6:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
                case 8:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
                case 9:
                case 10:
                     $lcCelda = "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
                     break;
             }
       }
  return $lcCelda ;
}

function fnNivel($codCata)
{
    $nlenCta = strlen($codCata);
    $lCodIni = substr($codCata,0,1);
    $lNivel  = 0;
    if ($lCodIni== "1" or $lCodIni== "2" or $lCodIni== "3")
       {
         switch ($nlenCta)
           {
             case 1:
                  $lNivel = 1;
                  break;
             case 3:
                  $lNivel = 2;
                  break;
             case 5:
                  $lNivel = 3;
                  break;
             case 7:
                  $lNivel = 4;
                  break;
             case 8:
             case 9:
             case 10:
                  $lNivel = 5;
                  break;
             default:
                  $lNivel = 0;
                  break;
          }
       }
    else
       {
        switch ($nlenCta)
           {
             case 2:
                  $lNivel = 1;
                  break;
             case 4:
                  $lNivel = 2;
                  break;
             case 6:
                  $lNivel = 3;
                  break;
             case 8:
                  $lNivel = 4;
                  break;
             case 10:
                  $lNivel = 5;
                  break;
             default:
                  $lNivel = 0;
                  break;
          }
       }
      Return $lNivel;
}

function fnFecha($lFecha)
{
  switch($lFecha)
     {
        case 1:
           // Pirmer dia del año
           $dias = date(z);
           $Fecha = date("Y-m-d",strtotime(date("Y-m-d")."- ".$dias." days")); 
           break;
        case 2:
           // Fecha Actual
           $Fecha = date("Y-m-d");
           break;
        case 3:
           //Feha actua menos dias
           $dias = date(j)-1;
           $Fecha = date("Y-m-d",strtotime(date("Y-m-d")."- ".$dias." days")); 
           break;
     }
  return $Fecha;
}

// Detalle de Retenciones
function prDetalleReten($lsecuen)
{
       include("../coneccion/DBConexion.php");

       echo '<table class="TablaGeneral" border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
       echo "<thead>";
       echo "<tr>";
       echo "<th>Forma</th>";
       echo "<th>Descripción</th>";
       echo "<th>Base Ret.</th>";
       echo "<th>% Ret.</th>";
       echo "<th>Cod.Ret.</th>";
       echo "<th>Valor</th>";
       echo "<th>Acción</th>";
       echo "</tr>";
       echo "</thead>";
       
       echo "<tbody style='max-height:100px; overflow:auto'>";

       $lcSql     = "select * from movicuenta where transac = 'DD' and secuencia = ".$lsecuen;
       $row_res   = $mySql->query($lcSql);
       $Sum_Total = 0.00 ;
       while($row_deta=mysqli_fetch_assoc($row_res))
        {
            $FormaPago = $row_deta['forma']  ;
            $DesForma  = $row_deta['desforma'] ;
            $BaseRet   = $row_deta['debito']  ;
            $Porcen    = $row_deta['porcen1'] ;
            $CodRet    = $row_deta['codreten']    ;
            $orden     = $row_deta['orden']   ;
            $lsecuen   = $row_deta['secuencia']   ;
            $Valor     = $row_deta['base']   ;
            $Sum_Total = $Sum_Total + $Valor;
            $Proceso   = 1 ;

            echo "<tr style='font-size:11px;'>";
            echo "<td >".$FormaPago."</td>";
            echo "<td>".$DesForma."</td>";
            echo "<td align = 'right'>".number_format($BaseRet,2)."</td>";
            echo "<td align = 'right'>".number_format($Porcen,2)."</td>";
            echo "<td align = 'right'>".$CodRet."</td>";
            echo "<td align = 'right'>".number_format($Valor,2)."</td>";
            echo "<td align = 'center'><input type='image' name='Eliminar' src='../Graficos/elimina.bmp' width='15' onclick='fnEliminaDeta(".$orden.",".$lsecuen.",".$Proceso.");fnTotalDinero(".$lsecuen.");'></td>";
            echo "</tr>";
        }
       echo "</tbody>";
       echo '</table>';
  Return;
}

//Cancelacion Otros Documentos 
function prPagoDocumento($lCompro, $lIdPers, $lFecIni, $lFecFin, $lNumIni, $lNumFin, $lEstabl, $lEmisio, $lFactur, $lModulo, $lDocu)
{
  include("../coneccion/DBConexion.php");
  
  if ($lModulo == '1')
     {
        $prefi = 'ccca_' ;
        $campo = "ccca_idcliente" ;
        $lcWhere = " " ;
     }
  else
     {
        $prefi = 'cpca_' ;
        $campo = "cpca_idprovee" ;
        $lcWhere = " " ;
     }
   
  $lcWhere = " " ;
  
  if (!empty($lFecIni) and !empty($lFecFin))
      $lcWhere = ' '.$prefi.'fecha between "'.$lFecIni.'" and "'.$lFecFin.'"';

  if (empty($lFecIni) and !empty($lFecFin))
      $lcWhere = ' and '.$prefi.'fecha <= "'.$lFecFin.'"' ;

  if (!empty($lFecIni) and empty($lFecFin))
      $lcWhere = ' and '.$prefi.'fecha => "'.$lFecIni.'"' ;

  if (!empty($lDocu))
     {
        if ($lDocu=='AN')
           $lCompro = '' ;
        $lcWhere .= " and ".$prefi."tipo = '".$lDocu."' " ;
     }
     
  //if (!empty($lCompro))
  //    $lcWhere .= " and ".$prefi."tipocompro = '".$lCompro."' " ;
  
  if (!empty($lIdPers))
      $lcWhere .= " and ".$campo." = '".$lIdPers."' " ;

  if ($lNumIni > 0 and $lNumFin > 0)
      $lcWhere .= " and ".$prefi."numero between ".$lNumIni." and ".$lNumFin ;

  if ($lNumIni > 0 and $lNumFin == 0)
      $lcWhere .= " and ".$prefi."numero >= ".$lNumIni ;

  if ($lNumIni == 0 and $lNumFin > 0)
      $lcWhere .= " and ".$prefi."numero <= ".$lNumFin ;

  if (!empty($lEstabl))
      {
         $lEstabl = substr('000'.trim($lEstabl),-3);
         $lcWhere .= " and substr(".$prefi."factura,1,3) = '".$lEstabl."'" ;
      }

  if (!empty($lEmisio))
     {
        $lEmisio = substr('000'.trim($lEmisio),-3);
        $lcWhere .= " and substr(".$prefi."factura,5,3) = '".$lEmisio."'" ;
     }

  if (!empty($lFactur))
     {
        $lFactur = substr('000000000'.trim($lFactur),-9);
        $lcWhere .= " and substr(".$prefi."factura,9,9) = '".$lFactur."'" ;
     }

  if ($lModulo == "1") 
      $lcSql = "Select * from cccabecera left join persona on pers_codigo = ccca_idcliente where ".$lcWhere." order by ccca_fecha desc";
  else
      $lcSql = "Select * from cpcabecera left join persona on pers_codigo = cpca_idprovee where ".$lcWhere." order by cpca_fecha desc";

   $row_fact = $mySql->query($lcSql);

   echo '<table class="TablaGeneral" border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
   echo '       <caption align="top"><h2>Documentos a Cancelar</h2></caption>';
   echo '<thead>';
   echo '   <tr>';
   echo '       <th>Comprobante</th>';
   echo '       <th>Número</th>';
   echo '       <th>Fecha</th>';
   echo '       <th>Documento</th>';
   echo '       <th>Identificacion</th>';
   echo '       <th>Nombre</th>';
   echo '       <th>Valor Deuda</th>';
   echo '       <th>Saldo a Cobrar</th>';
   echo '       <th>Pago</th>';
   echo '   </tr>';
   echo '</thead>';
   echo '<tbody>';

   while ($row_docu=mysqli_fetch_assoc($row_fact))
         {
               $Tipo     = $row_docu[$prefi."tipocompro"] ;
               $Numero   =  $row_docu[$prefi."numero"] ;
               $Fecha    = $row_docu[$prefi."fecha"] ;
               $Factu    = $row_docu[$prefi."estable"] ;
               $Factu    = $Factu."-".$row_docu[$prefi."emision"] ;
               $Factu    = $Factu."-".$row_docu[$prefi."secuen"] ;
               $Debito   = $row_docu[$prefi."debito"] ;
               $Credito  = $row_docu[$prefi."credito"] ;
               $IdCabe   = $row_docu[$prefi."idcabecera"] ;
               $IdPers   = $row_docu["pers_codigo"] ;
               $NomPer   = $row_docu["pers_nombre"] ;

               if ($lModulo == '1')
                  {
//                      $IdPers   = $row_docu["cccl_codigo"] ;
//                      $NomPer   = $row_docu["cccl_nombre"] ;
                     $lcSql    = "Select * from ccdetalle where ccde_idcabecera = '".$IdCabe."' order by ccde_fecha";
                     $camDeb = "ccde_debito" ;
                     $camCre = "ccde_credito" ;
                 
                     if (empty($lDocu))
                         $lFil = 0;
                     else
                         $lFil = 1 ;
                 
                     $Enlace = "<td align = 'center'> <a title='Pago Documento' href='../CxC/ccIngresoDocumento.php?keyId=".$IdCabe."&filtro=".$lFil."' target='_blank'> <img src='../Graficos/Actualiza.bmp' width=20 height=20 /></a> </td>";
                  }
               else
                  {
//                      $IdPers = $row_docu["cppr_codigo"] ;
//                      $NomPer = $row_docu["cppr_nombre"] ;
                     $lcSql  = "Select * from cpdetalle where cpde_idcabecera = '".$IdCabe."' order by cpde_fecha";
                     $camDeb = "cpde_credito" ;
                     $camCre = "cpde_debito" ;
                 
                     if (empty($lDocu))
                         $lFil = 0;
                     else
                         $lFil = 1 ;

                 
                     $Enlace = "<td align = 'center'> <a title='Pago Documento' href='../CxP/cpPagoDocumento.php?keyId=".$IdCabe."&filtro=".$lFil."' target='_blank'> <img src='../Graficos/Actualiza.bmp' width=20 height=20 /></a> </td>";
                  }

               $lValor   = 0;
               
               $row_deta = $mySql->query($lcSql);
               while ($row_pago=mysqli_fetch_assoc($row_deta))
                    {
                       $lValor = $lValor + $row_pago[$camDeb] - $row_pago[$camCre] ;
                    }
               if ($Debito > 0)
                  {
                     $Saldo = $Debito + $lValor ;
                     $Valor = $Debito ;
                  }
               else
                  {
                     $Saldo = $Credito - $lValor ;
                     $Valor = $Credito ;
                  }

               echo "<tr>" ;
               echo "<td>".$Tipo."</td>";
               echo "<td>".$Numero."</td>";
               echo "<td>".obtenerFechaEnLetra($Fecha,1)."</td>";
               echo "<td>".$Factu."</td>";
               echo "<td>".$IdPers."</td>";
               echo "<td>".$NomPer."</td>";
               echo "<td align = 'right'>".number_format($Valor,2)."</td>";
               echo "<td align = 'right'>".number_format($Saldo,2)."</td>";
               echo $Enlace ;
               echo "</tr>"; 
         }
   echo '</tbody>';
   echo '</table>';
} 


//Cancelacion Otros Documentos 
Function prAnticpoDocumento($lIdPers, $lcEsta, $lModulo)
{
   include("../coneccion/DBConexion.php");
  
  if ($lModulo == '1')
     {
        $prefi = 'ccca_' ;
        $campo = "ccca_idcliente" ;
     }
  else
     {
        $prefi = 'cpca_' ;
        $campo = "cpca_idprovee" ;
     }
    
  if (!empty($lIdPers))
      $lcWhere .= " and ".$campo." = '".$lIdPers."' " ;

  if ($lNumIni > 0 and $lNumFin > 0)
      $lcWhere .= " and ".$prefi."numero between ".$lNumIni." and ".$lNumFin ;

  if ($lNumIni > 0 and $lNumFin == 0)
      $lcWhere .= " and ".$prefi."numero >= ".$lNumIni ;

  if ($lNumIni == 0 and $lNumFin > 0)
      $lcWhere .= " and ".$prefi."numero <= ".$lNumFin ;

  if (!empty($lEstabl))
      {
         $lEstabl = substr('000'.trim($lEstabl),-3);
         $lcWhere .= " and substr(".$prefi."factura,1,3) = '".$lEstabl."'" ;
      }

  if (!empty($lEmisio))
     {
        $lEmisio = substr('000'.trim($lEmisio),-3);
        $lcWhere .= " and substr(".$prefi."factura,5,3) = '".$lEmisio."'" ;
     }

  if (!empty($lFactur))
     {
        $lFactur = substr('000000000'.trim($lFactur),-9);
        $lcWhere .= " and substr(".$prefi."factura,9,9) = '".$lFactur."'" ;
     }

  if ($lModulo == "1") 
      $lcSql = "Select * from cccabecera, cccliente where ccca_idcliente = cccl_codigo and ".$lcWhere." order by ccca_fecha desc";
  else
      $lcSql = "Select * from cpcabecera, cpproveedor where cpca_idprovee = cppr_codigo and ".$lcWhere." order by cpca_fecha desc";

   $row_fact = $mySql->query($lcSql);

   echo '<table class="TablaGeneral" border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
   echo '       <caption align="top"><h2>Documentos a Cancelar</h2></caption>';
   echo '<thead>';
   echo '   <tr>';
   echo '       <th>Comprobante</th>';
   echo '       <th>Número</th>';
   echo '       <th>Fecha</th>';
   echo '       <th>Documento</th>';
   echo '       <th>Identificacion</th>';
   echo '       <th>Nombre</th>';
   echo '       <th>Valor Deuda</th>';
   echo '       <th>Saldo a Cobrar</th>';
   echo '       <th>Pago</th>';
   echo '   </tr>';
   echo '</thead>';
   echo '<tbody>';

   while ($row_docu=mysqli_fetch_assoc($row_fact))
         {
               $Tipo     = $row_docu[$prefi."tipocompro"] ;
               $Numero   =  $row_docu[$prefi."numero"] ;
               $Fecha    = $row_docu[$prefi."fecha"] ;
               $Factu    =  $row_docu[$prefi."factura"] ;
               $Debito   = $row_docu[$prefi."debito"] ;
               $Credito  = $row_docu[$prefi."credito"] ;
               $IdCabe   = $row_docu[$prefi."idcabecera"] ;
         
               if ($lModulo == '1')
                  {
                     $IdPers   = $row_docu["cccl_codigo"] ;
                     $NomPer   = $row_docu["cccl_nombre"] ;
                     $lcSql    = "Select * from ccdetalle where ccde_idcabecera = '".$IdCabe."' order by ccde_fecha";
                     $camDeb = "ccde_debito" ;
                     $camCre = "ccde_credito" ;
                     $Enlace = "<td align = 'center'> <a title='Pago Documento' href='../CxC/ccIngresoDocumento.php?keyId=".$IdCabe."' target='_blank'> <img src='../Graficos/Actualiza.bmp' width=20 height=20 /></a> </td>";
                  }
               else
                  {
                     $IdPers = $row_docu["cppr_codigo"] ;
                     $NomPer = $row_docu["cppr_nombre"] ;
                     $lcSql  = "Select * from cpdetalle where cpde_idcabecera = '".$IdCabe."' order by cpde_fecha";
                     $camDeb = "cpde_debito" ;
                     $camCre = "cpde_credito" ;
                     $Enlace = "<td align = 'center'> <a title='Pago Documento' href='../CxP/cpPagoDocumento.php?keyId=".$IdCabe."' target='_blank'> <img src='../Graficos/Actualiza.bmp' width=20 height=20 /></a> </td>";
                  }

               $lValor   = 0;
               
               $row_deta = $mySql->query($lcSql);
               while ($row_pago=mysqli_fetch_assoc($row_deta))
                    {
                       $lValor = $lValor + $row_pago[$camDeb] - $row_pago[$camCre] ;
                    }
               if ($Debito > 0)
                  {
                     $Saldo = $Debito + $lValor ;
                     $Valor = $Debito ;
                  }
               else
                  {
                     $Saldo = $Credito - $lValor ;
                     $Valor = $Credito ;
                  }

               echo "<tr>" ;
               echo "<td>".$Tipo."</td>";
               echo "<td>".$Numero."</td>";
               echo "<td>".obtenerFechaEnLetra($Fecha,1)."</td>";
               echo "<td>".$Factu."</td>";
               echo "<td>".$IdPers."</td>";
               echo "<td>".$NomPer."</td>";
               echo "<td align = 'right'>".number_format($Valor,2)."</td>";
               echo "<td align = 'right'>".number_format($Saldo,2)."</td>";
               echo $Enlace ;
               echo "</tr>"; 
         }
   echo '</tbody>';
   echo '</table>';
} 

function prNominaGene($lSql, $lnmes, $lano)
{
   include("../coneccion/DBConexion.php");
  
      echo '<caption align="top"><h1>HORAS DE TRABAJO</h1></caption>';
      echo "<thead>";
      echo "<tr>";
      echo "    <th colspan=15>MARCACION DEL MES DE ".$lnmes." DEL AÑO ".$lano."</th>";
      echo "</tr>";
  
      echo "<tr>" ;
      echo "<th>Código</th>" ;
      echo "<th>Nombre</th>" ;
      echo "<th>Horas</th>" ;
      echo "<th>Sueldo</th>" ;
      echo "<th>H. Atraso</th>" ;
      echo "<th>V. Atraso</th>" ;
      echo "<th>H. HE 25%</th>" ;
      echo "<th>V. HE 25%</th>" ;
      echo "<th>H. HE 50%</th>" ;
      echo "<th>V. HE 50%</th>" ;
      echo "<th>H. HE 100%</th>" ;
      echo "<th>V. HE 100%</th>" ;
      echo "<th>H.JUSTI.</th>" ;
      echo "<th>V.JUSTI.</th>" ;
      echo "<th>TOTAL</th>" ;
      echo "</tr>" ;
      echo "<tbody>" ;
      echo "<tr>" ;

      $row_mar = $mySql->query($lSql);
      while($row_hora=mysqli_fetch_assoc($row_mar))
        {
            $codigo = $row_hora["pers_codigo"] ;
            $nombre = $row_hora["pers_nombre"] ;
            $tipo   = $row_hora["noho_tipo"] ;
            $horas  = $row_hora["noho_horas"] ;
            $valor  = $row_hora["noho_valor"] ;
            $hatras = $row_hora["noho_atraso"] ;
            $he25   = $row_hora["noho_he25"] ;
            $he50   = $row_hora["noho_he50"] ;
            $he100  = $row_hora["noho_he100"] ;
    
            $sulhor = $valor/240 ;
    
            $vatras = $sulhor*$hatras ;
            $hev25  = $sulhor*0.25*$he25 ;
            $hev50  = $sulhor*1.5*$he50 ;
            $hev100 = $sulhor*2*$he100 ;
    
            $total = $valor + $hev25 + $hev50 + $hev100 - $vatras ;
    
            echo '<td>'.$codigo.'</td>' ;
            echo '<td><FONT SIZE=2>'.$nombre.'</font></td>' ;
//            echo '<td>'.$nombre.'</td>' ;
            echo '<td>'.$horas.'</td>' ;
            echo "<td  align = 'right'>".number_format($valor,2)."</td>"  ;
            echo "<td  align = 'right'>".number_format($hatras,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($vatras,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($he25,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($hev25,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($he50,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($hev50,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($he100,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($hev100,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($hev100,2)."</td>" ;
            echo "<td  align = 'right'>".number_format($hev100,2)."</td>" ;
            echo "<td  align = 'right'><b>".number_format($total,2)."</b></td>" ;
            echo "</tr>";
        }
  echo "</tbody>";
  echo "</table>";  

}

function MesesSelect()
{
       $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio", "Agosto","Septiembre","Octubre","Noviembre","Diciembre");
       $array = $meses; 
       $j     = 0;
       for ($i=0 ; $i < sizeof($array); $i++)
             {
               $selEs = '' ;
               $j=$i+1;
               if ($i==date(n)-1)
                   $selEs = 'selected' ;
         
               echo '<option value="'.$j.'" '.$selEs.'>'.$array[$i].'</option>';
             }
} 

function prImprime($lSql, $lReporte)
{
  include("../coneccion/DBConexion.php");
  
  switch ($lReporte)
    {
      case "NoJus":
          echo '<table class ="TablaGeneral" border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
          echo '<caption align="top"><h1>REGISTRO DE JUSTIFICACIONES</h1></caption>';
          echo "<thead>";
          echo "<tr>";
          echo "<th>Código</th>";
          echo "<th>Nombre</th>";
          echo "<th>Fecha</th>";
          echo "<th>Entrada</th>";
          echo "<th>Salida</th>";
          echo "</tr>";
          echo "</thead>";
          echo "<tbody>";

          $lcSql = 'select * from nojustifica left join persona on pers_codigo = noca_codigo left join empleado on empl_codigo = noca_codigo left join nonovedad on nono_codigo = noca_novedad where noca_fv = "V" order by pers_nombre, noca_novedad ' ;
          $row_emp = $mySql->query($lcSql);

         while($row_empl=mysqli_fetch_assoc($row_emp))
              {
                 $codigo = $row_empl['empl_codigo'] ;
                 $nombre = $row_empl['pers_nombre'] ;
                 $nove   = $row_empl['noca_novedad'] ;
                 $novd   = $row_empl['nono_descrip'] ;
                 $valor  = $row_empl['noca_valor'] ;
    
                 $tvalor = $tvalor + $valor ;
           
                 echo "<tr>";
                 echo "<td>".$codigo."</td>";
                 echo "<td>".$nombre."</td>";
                 echo "<td>".$nove." - ".$novd."</td>";
                 echo "<td align='Right'>".number_format($valor,2)."</td>" ;
                 echo "</tr>";
              }
         echo "</tbody>";
         echo "<tfoot>";
         echo "<tr>";
         echo "<th colspan=3>TOTAL REPORTE</th>";
         echo "<th align='Right'>".number_format($tvalor,2)."</th>" ;
         echo "</tr>";
         echo "</tfoot>";
         echo "</table>";
         break;
      case "NoJus":
           break;
    }
    
}

// Detalle de Articulos
// Comprobante de Inventario
function prDetalleArti($lsecuen, $lnMues)
{
  include("../coneccion/DBConexion.php");

  if ($lnMues == 1 or $lnMues == 2 or $lnMues == 3)
     {
       echo '<table class="TablaGeneral" width = "60%"  border="1" align="center" cellpadding="0" cellspacing="0" bordercolor="#000F1F" style="oveflow:auto;">';
       echo '<caption align="top"><h2>Articulos</h2></caption>' ;

       echo "<thead>";
       echo "<tr>";
       echo "<th>Linea</th>";
       echo "<th>Articulo</th>";
       echo "<th>Descripción</th>";
       echo "<th>Unidad</th>";
       echo "<th>Cantidad</th>";
       echo "<th>Precio</th>";
       echo "<th>Total</th>";
       
       switch($lnMues)
         {
            case 1:
            case 2:
               echo "<th>Acción</th>";
               break;
            case 3:
               echo "<th>Facturar</th>";
               echo "<td align = 'center'><input type='image' name='Ninguno' src='../Graficos/primero.BMP' width='15' onclick='fnFactArt(-1,2)'></td>";
               echo "<td align = 'center'><input type='image' name='Todos'   src='../Graficos/ultimo.BMP'  width='15' onclick='fnFactArt(-1,0)'></td>";
               break;
         }
    
       echo "</tr>";
       echo "</thead>";
       
       echo "<tbody style='max-height:100px; overflow:auto'>";

       $lcSql   = "select * from movicuenta where secuencia = ".$lsecuen." order by orden";
       $row_que = $mySql->query($lcSql);
       $linea   = 1 ;
       $totmovi = 0.00 ;
       while($row_pedi=mysqli_fetch_assoc($row_que))
        {
            $codarti = $row_pedi['ddescri']  ;
            $desarti = $row_pedi['glosa'] ;
            $uniarti = $row_pedi['codreten']  ;
            $canarti = $row_pedi['porcen1']  ;
            $valarti = $row_pedi['debito']  ;
            $totarti = $canarti*$valarti ;
            $totmovi = $totmovi + $totarti ; 
            $orden   = $row_pedi['orden']  ;
            $lsecuen = $row_pedi['secuencia']  ;
            $Proceso = 5 ;
         
            echo "<tr>";
            echo "<td style='font-size:12px;'>".$orden."</td>";
            echo "<td style='font-size:12px;'>".$codarti."</td>";
            echo "<td style='font-size:12px;'>".$desarti."</td>";
            echo "<td style='font-size:12px;' align = 'right'>".$uniarti."</td>";
            echo "<td style='font-size:12px;' align = 'right'>".number_format($canarti,2)."</td>";
            echo "<td style='font-size:12px;' align = 'right'>".number_format($valarti,2)."</td>";
            echo "<td style='font-size:12px;' align = 'right'>".number_format($totarti,2)."</td>";
            
            switch($lnMues)
              {
                case 1:
                case 2:
                    $disabled = "" ;
                    if ($lnMues==2)
                       $disabled = "hidden" ;
                    echo "<td align = 'center'><input type='image' name='Eliminar' src='../Graficos/elimina.bmp' width='15' onclick='fnEliminaDeta(".$orden.",".$lsecuen.",".$Proceso.");' ".$disabled."></td>";
                    break;
                case 3:
                    echo "<td align = 'center'><input type='checkbox' class='factura' id='factu_".$orden."' name='factu_".$orden."' value='1' onclick='fnFactArt(".$orden.",1); '></td>";
                    break;
              }
            
            echo "</tr>";
            $linea ++ ;
        }
      echo "</tbody>";
      echo "<tfoot>";

       echo "<tr>";
       echo "<th colspan = 6 align = 'center'><B>TOTAL MOVIMIENTO</B></td>";
       echo "<th align = 'right'><B><H4>".number_format($totmovi,2)."</H4></B></th>";
    
       if ($lnMues < 3)
          echo "<th></th>";
    
       echo "</tr>"    ;
       echo "</tfoot>"  ;
       echo '</table>';

     }
}


function fnSaldoInv($prod, $bode, $fech)
{
  include("../coneccion/DBConexion.php");

  $lcCondi = " inca_fecha <= '".$fech."'";
  
  if (!empty($prod))
      $lcCondi .= " and inde_articulo = '".$prod."'";
  
  if (!empty($bode))
      $lcCondi .= " and inca_bodega = '".$bode."'";
  
  $lcSql = "select intc_tipo, inca_fecha, inde_articulo, sum(saldo) saldo from detalleinv where ".$lcCondi." order by inca_fecha, intc_tipo desc, inca_tipo";
  $row_que = $mySql->query($lcSql);
  
  $total = 0.00 ;
  while($row_sal=mysqli_fetch_assoc($row_que))
       {
             $canti = $row_sal["saldo"];
       }
  return $canti ;
}

// Crea nueva fecha
function fnOpeFec($lFec, $Dias, $signo)
{
  $fecnu = date("Y-m-d",strtotime($lFec." ".$signo." ".$Dias." days"));
  
  return $fecnu ;
}  

// Devuelve el campo de una tabla segun la condicion
function fnDevuelveCampo($lCampo, $lTabla, $lCondi)
 {
   include("../coneccion/DBConexion.php");
  
   $lcSql = "select ".$lCampo." campo from ".$lTabla. " where ".$lCondi;
   //echo "Sentencia => ".$lcSql ;
   $que=$mySql->query($lcSql);
   while($row_que=mysqli_fetch_assoc($que))
        {
              $lcCampo   = $row_que["campo"];
        }

   return $lcCampo ;
 }

?>