// Funciones Generales Ajax
function fnGrabaDocu() {
  xasync = false;
  var grTabla = "cgcabecera";
  var prefijo = "cgca_";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lIdPr = "";
  var lNoPr = "";
  var lSust = "";
  var lTDoc = "";
  var lPunt = "";
  var lEmis = "";
  var lNume = "";
  var lVenc = "";
  var lAuto = "";
  var lImpr = "";
  var lVali = "";
  var lBas0 = 0.00;
  var lBasG = 0.00;
  var lBasE = 0.00;
  var lPIva = "";
  var lDeIv = "";
  var lCaja = "";
  var lNChq = 0;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;

      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        fnsweetalert("Diccionario de Errores", lcMsg, "error", 1);
      } else {
        document.getElementById('numCompro').value = $(dato).find("numdocu").text();
        var lcTexto = "Diario Grabado : " + lTipo + " - " + $(rdata).find("numdocu").text();
        fnsweetalert("Proceso Termina", lcTexto, "success", 1);
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Grabacion Docuemnto');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Documento Grabado');
    }
  })
  return rdata;
}

// Graba Catalogo
function fnGrabaCatalogo() {
  xasync = false;
  var grTabla = "cgcatalogo";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('codigo').value;
  var lDesc = document.getElementById('descrip').value;
  var lInte = document.getElementById('interface').value;
  var lTiCu = document.getElementById('tipoCuenta').value;
  var lEnti = document.getElementById('entidad').value;
  var lTiBa = document.getElementById('tipoBanco').value;
  var lNuCu = document.getElementById('numcta').value;
  var lCheq = document.getElementById('numcheque').value;
  var lRetF = document.getElementById('codFuente').value;
  var lRetI = document.getElementById('codIva').value;
  var lPorF = document.getElementById('porFue').value;
  var lPor1 = document.getElementById('porIva').value;
  var lPor2 = document.getElementById('RetIva').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      codigo: lCodi,
      descrip: lDesc,
      interfa: lInte,
      tipoCuenta: lTiCu,
      entidad: lEnti,
      tipoBanco: lTiBa,
      numcta: lNuCu,
      numCheque: lCheq,
      codFue: lRetF,
      codIva: lRetI,
      porFue: lPorF,
      porIva1: lPor1,
      porIva2: lPor2,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;

      //window.close();
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Disculpe, existió un problema');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      var lcMensaje = "Cuenta Grabada : " + lCodi + " - " + lDesc;
      var lcAccion = "success";

      fnsweetalert('Proceso Terminado', lcMensaje, lcAccion, 1, '', rdata);
    }
  })
  return rdata;
}


// Graba Cliente
function fnGrabaCliente() {
  xasync = true;
  var msgalert, msgerror, msgsistemas;

  var grTabla = document.getElementById('dbTabla').value;
  var prefijo = document.getElementById('dbPrefi').value;

  var lCodi = document.getElementById('codigo').value;
  var lIden = document.getElementById('tipoIdenti').value;
  var lDesc = document.getElementById('descrip').value;
  var lBene = document.getElementById('nombre').value;
  var lCont = document.getElementById('contacto').value;
  var lTele = document.getElementById('telefono').value;
  var lCelu = document.getElementById('celular').value;
  var lPlaz = document.getElementById('plazo').value;
  var lDire = document.getElementById('direccion').value;
  var lCiud = document.getElementById('ciudad').value;
  var lPais = document.getElementById('pais').value;
  var lTiPe = document.getElementById('tipoPersona').value;
  var lTiNe = document.getElementById('tipoNegocio').value;
  var lemai = document.getElementById('email').value;
  var lFaEl = document.getElementById('factelec').value;
  var lTiCo = document.getElementById('tipoCompra').value;
  var lProv = document.getElementById('ctaProveedor').value;
  var lGast = document.getElementById('ctaGasto').value;
  var lIva = document.getElementById('ctaIva').value;
  var lAnti = document.getElementById('ctaAnticipo').value;
  var lReFu = document.getElementById('ctaRetFue').value;
  var lReIv = document.getElementById('ctaRetIva').value;
  var lTiPa = document.getElementById('TipoPago').value;
  var lPaPa = document.getElementById('PaisPago').value;
  var lFpa1 = document.getElementById('FormaPago1').value;
  var lFpa2 = document.getElementById('FormaPago2').value;

  // Valor Radio Buttons
  var lCaBe = document.fCambia.CambiaBene.value;
  var lRela = document.fRela.Relaciona.value;
  var lSeIv = document.fSepa.SpIva.value;
  var lTrib = document.fTrib.Tributa.value;
  var lSuje = document.fSuje.Sujeto.value;
  var lFisc = document.fFisc.Fiscal.value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      codigo: lCodi,
      descrip: lDesc,
      tablaGr: grTabla,
      campo: prefijo,
      tipoid: lIden,
      benefi: lBene,
      cambia: lCaBe,
      contac: lCont,
      tele: lTele,
      celu: lCelu,
      dire: lDire,
      dias: lPlaz,
      ciud: lCiud,
      pais: lPais,
      tipe: lTiPe,
      tine: lTiNe,
      mail: lemai,
      fael: lFaEl,
      tico: lTiCo,
      cpro: lProv,
      cgas: lGast,
      civa: lIva,
      cant: lAnti,
      crfu: lReFu,
      criv: lReIv,
      tipa: lTiPa,
      papa: lPaPa,
      fpa1: lFpa1,
      fpa2: lFpa2,
      rela: lRela,
      seiv: lSeIv,
      trib: lTrib,
      suje: lSuje,
      fisc: lFisc
    },

    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      var lPerso = "Proveedor ";
      //alert(dato);
      if (prefijo === "cccl_")
        lPerso = "Cliente ";

      let lcMsj = lPerso + "Grabado ..." + lCodi + " " + lDesc;
      fnsweetalert("Proceso Terminano", lcMsj, 'success', 1);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Grabación de Clientes');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Cliente Grabado...' + lCodi);
    }
  })
  return rdata;
}

// Graba Items en Temporal de Facturas
function fnGrabaDetaFac() {
  xasync = false;
  var grTabla = "cxcmovicuenta";
  var msgalert, msgerror, msgsistemas;

  var lEmis = document.getElementById('emision').value;
  var lEsta = document.getElementById('estable').value;
  var lNume = document.getElementById('secuencia').value;
  var lItem = document.getElementById('Producto').value;
  var lDesc = document.getElementById('DDescrip').value;
  var lGlos = document.getElementById('Glosa').value;
  var lPiva = document.getElementById('Iva').value;
  var lCant = document.getElementById('Cantidad').value;
  var lValo = document.getElementById('Valor').value;
  var lCodi = document.getElementById('CtaGasto').value;
  var lDpto = document.getElementById('Dpto').value;
  var lArea = document.getElementById('Area').value;

  var lSecu = Number.parseInt(lEmis, 10) + Number.parseInt(lEsta, 10) + Number.parseInt(lNume, 10);
  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      items: lItem,
      descrip: lDesc,
      glosa: lGlos,
      iva: lPiva,
      valor: lValo,
      cantidad: lCant,
      tablaGr: grTabla,
      emision: lEsta,
      estable: lEmis,
      factura: lNume,
      codigo: lCodi,
      dpto: lDpto,
      area: lArea,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //             alert(dato);
      rdata = dato;
      document.getElementById('base0').value = $(dato).find("Base0").text();
      document.getElementById('base12').value = $(dato).find("Base12").text();
      document.getElementById('valorIva').value = $(dato).find("ValIva").text();
      document.getElementById('Total').value = $(dato).find("TotalFac").text();

      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        fnsweetalert("Dicionario de Errores", lcError, "error", 1);
      } else {
        fnsweetalert("Proceso Correcto", "Producto Registrado", "success", 1, );
      }
      document.getElementById('detall').innerHTML = $(dato).find("TablaTest").html();


    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      fnsweetalert("Error", "En Ingreso de Factura", "error", 1);
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Producto Registrado');
    }
  })
  return rdata;
}

//Datos de Factura de Clientes
function fnDatosClie() {
  xasync = true;
  var grTabla = "ccclienteDat";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('idCliente').value;
  var lEsta = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lSecu = document.getElementById('secuencia').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  lEsta = '000' + lEsta;
  lEmis = '000' + lEmis;
  lSecu = '000000000' + lSecu;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      Cliente: lCodi,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;
      document.getElementById('Direccion').value = $(dato).find("Direccion").text();
      document.getElementById('email').value = $(dato).find("Email").text();
      document.getElementById('telefono').value = $(dato).find("Telefono").text();
      document.getElementById('celular').value = $(dato).find("Celular").text();
      document.getElementById('CtaCxC').value = $(dato).find("CtaCxC").text();
      document.getElementById('CtaGasto').value = $(dato).find("CtaGasto").text();
      document.getElementById('plazo').value = $(dato).find("Credito").text();

      document.getElementById('estable').value = lEsta.substr(-3);
      document.getElementById('emision').value = lEmis.substr(-3);
      document.getElementById('secuencia').value = lSecu.substr(-9);

      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Error : \n" + lcMsg);
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Información de Cliente');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Datos Cargados Correctamente');
    }
  })
  return rdata;
}

// Graba Factura de Clientes
function fnGrabaFact() {
  xasync = false;
  var grTabla = "facabecera";
  var msgalert, msgerror, msgsistemas;

  var lDocu = document.getElementById('documento').value;
  var lEmis = document.getElementById('emision').value;
  var lEsta = document.getElementById('estable').value;
  var lNume = document.getElementById('secuencia').value;
  var lFech = document.getElementById('fecha').value;
  var lidCl = document.getElementById('idCliente').value;
  var lGlos = document.getElementById('detalle').value;
  var lDias = document.getElementById('plazo').value;
  var lSecu = Number.parseInt(lEmis, 10) + Number.parseInt(lEsta, 10) + Number.parseInt(lNume, 10);

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      estable: lEsta,
      emision: lEmis,
      factura: lNume,
      fecha: lFech,
      Cliente: lidCl,
      detalle: lGlos,
      Dias: lDias,
      Docu: lDocu,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;

      document.getElementById('tipoCompro').value = $(dato).find("tipodocu").text();
      document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Facturación');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Factura Registrada');
    }
  })
  return rdata;
}

// Graba Deposito Normal Temporal
function fnGrabaDeposito() {

  document.getElementById('DCuenta').value = document.getElementById('CtaCaja2').value;
  document.getElementById('DDescrip').value = document.getElementById('cjDescrip').value;
  document.getElementById('DCredito').value = document.getElementById('deposito').value;
  document.getElementById('detalle').innerHTML = "DEPOSITO DEL DIA " + document.getElementById('fecha').value;

  return;
}

//Graba Deposito Real
function fnGrabaBcoIng() {
  xasync = false;
  var grTabla = "cgcabecera1";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCaja = document.getElementById('CtaCaja').value;
  var lCaja2 = document.getElementById('CtaCaja2').value;
  var lCodi = document.getElementById('idCliente').value;
  var lBene = document.getElementById('DCDescrip').value;
  var lValo = document.getElementById('TotalCxC').value;
  var lDepo = document.getElementById('deposito').value;
  var lReca = document.getElementById('idRecauda').value;
  var lOpcion = document.getElementById("opIngreso");
  var opSele = lOpcion.value;
  switch (opSele) {
    case 'A':
      grTabla = "cgcabecera1";
      break;
    case 'P':
      grTabla = "cgcabecera2";
      break;
    case 'V':
      grTabla = "cgcabecera";
      break;
    case 'N':
      grTabla = "cgcabecera7";
      break;
  }
  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      CtaCaja: lCaja,
      idProve: lCodi,
      beneficiario: lBene,
      NumChq: 0,
      ValDin: lValo,
      Recauda: lReca
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      rdata = dato;
      var lcMsg = '';
      var Numero = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        fnsweetalert("Error en Proceso", lcMsg, "error", 1);

      } else {
        lcMsg = lGraba + " " + lTipo + " - " + Numero;
        fnsweetalert("Proceso Terminado", lcMsg, "success", 1);
        document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      }



    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert(lGraba);
    }
  })
  return rdata;
}

// Anticipo Clientes
function fnGrabaAntiCxC() {
  xasync = false;
  var grTabla = "cxccabecera";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('idCliente').value;
  var lAnti = document.getElementById('Anticipo').value;
  var lSecu = document.getElementById('DSecuen').value;


  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Cliente: lCodi,
      Antici: lAnti,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lTit = '';
      var lAcc = '';
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        lTit = "Diccionario de Errores";
        lAcc = "error";
      } else {
        var lDeta = document.getElementById('DCDescrip').value;
        document.getElementById('DGlosa').value = "ANTICIPO CLIENTE " + lDeta;
        document.getElementById('DCuenta').value = $(dato).find("Anticipo").text();
        document.getElementById('DDescrip').value = $(dato).find("Descripcion").text();
        document.getElementById('DCredito').value = document.getElementById('Anticipo').value;
        document.getElementById('detalle').innerHTML = "ANTICIPO CLIENTE " + lDeta;
        document.getElementById('TotalCxC').value = lAnti;
        lTit = "Proceso Terminado";
        lcMsg = "Asignacion de cuentas Contables";
        lAcc = "success";
      }
      fnsweetalert(lTit, lcMsg, lAcc, 1);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Anticipo CxC');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Anticipo De Clientes');
    }
  })
  return rdata;
}

// Anticipo Deposito Normal


//Graba Detalle Contable Temporal
function fnGrabaDeta() {
  xasync = false;
  var grTabla = "movicuenta";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('DCuenta').value;
  var lDesc = document.getElementById('DDescrip').value;
  var lGlos = document.getElementById('DGlosa').value;
  var lDebi = document.getElementById('DDebito').value;
  var lCred = document.getElementById('DCredito').value;
  var lDpto = document.getElementById('DDpto').value;
  var lDesD = document.getElementById('DDDescrip').value;
  var lArea = document.getElementById('DArea').value;
  var lDesA = document.getElementById('DADescrip').value;
  var lSecu = document.getElementById('DSecuen').value;


  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      codigo: lCodi,
      descrip: lDesc,
      glosa: lGlos,
      debi: lDebi,
      cred: lCred,
      dpto: lDpto,
      ddesc: lDesD,
      area: lArea,
      adesc: lDesA,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //console.log(dato);
      //alert(dato);
      var lTit = "";
      var lAcc = '';

      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        lTit = "Dicionario de Errores";
        lAcc = 'error';
      } else {
        document.getElementById('DDebito').value = 0.00;
        document.getElementById('DCredito').value = 0.00;
        var xdeb = $(dato).find("xDeb").text();
        var xcre = $(dato).find("xCre").text();
        xdeb = parseFloat(xdeb);
        xcre = parseFloat(xcre);

        xdeb = xdeb.toFixed(2);
        xcre = xcre.toFixed(2);

        if (xdeb > xcre)
          document.getElementById('DCredito').value = xdeb - xcre;
        else
          document.getElementById('DDebito').value = xcre - xdeb;

        var lElem = document.getElementById('CtaCaja2');

        if (lElem) {
          document.getElementById('TotalCxC').value = xcre - xdeb;
        }

        document.getElementById('DCuenta').value = "";
        document.getElementById('DDescrip').value = "";
        document.getElementById('detall').innerHTML = $(dato).find("TablaTest").html();

        lTit = "Proceso Terminado";
        lcMsg = "Cuenta Asignada " + lCodi;
        lAcc = 'success';
      }
      fnsweetalert(lTit, lcMsg, lAcc, 1);

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Cuentas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Cuenta Agregada');
    }
  })
  return rdata;
}

function fnGrabaCajaIng() {
  xasync = false;
  var grTabla = "cgcabecera1";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCaja = document.getElementById('CtaCaja').value;
  var lCaja2 = document.getElementById('CtaCaja2').value;
  var lCodi = document.getElementById('idCliente').value;
  var lBene = document.getElementById('DCDescrip').value;
  var lValo = document.getElementById('PagoValor').value;
  var lReca = document.getElementById('idRecauda').value;
  var lDepo = document.getElementById('TotalCxC').value;

  var lOpcion = document.getElementById("opIngreso");
  var opSele = lOpcion.value;
  var lGraba = '';

  if (lTipo == 'DEPOS')
    lGraba = 'DEPOSITO BANCARIO GRABADO';
  else
    lGraba = 'INGRESO A CAJA GRABADO'

  switch (opSele) {
    case 'A':
      grTabla = "cgcabecera1";
      break;
    case 'P':
      grTabla = "cgcabecera2";
      break;
    case 'V':
      grTabla = "cgcabecera";
      break;
    case 'N':
      grTabla = "cgcabecera7";
      break;
  }
  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      CtaCaja: lCaja,
      CtaCaja2: lCaja2,
      idProve: lCodi,
      beneficiario: lBene,
      NumChq: 0,
      ValDin: lValo,
      Deposi: lDepo,
      Recauda: lReca
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      //console.log(dato);
      rdata = dato;
      var lcMsg = '';
      var Numero = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        fnsweetalert("Error en Proceso", lcMsg, "error", 1);

      } else {
        lcMsg = lGraba + " " + lTipo + " - " + Numero;
        fnsweetalert("Proceso Terminado", lcMsg, "success", 1);
        document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      }



    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert(lGraba);
    }
  })
  return rdata;
}

// Facturas CxC por Cliente
function fnAbonoFactCxC() {
  xasync = false;
  var grTabla = "cccabecera";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('idCliente').value;
  var lSecu = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  hide_docu1('Dinero');

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Cliente: lCodi,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      fnsweetalert("Proceso Correcto", "Facturas a Cancelar", "success", 1);
      document.getElementById('pagos').innerHTML = $(dato).find("TablaCxC").html();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      //alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Facturas Pendientes');
    }
  })
  return rdata;
}

// Abona Facturas CxC
function fnActualPagoCxC(lIdCabe) {

  var grTabla = "cxcfactura";
  var cIdCabe = lIdCabe.toString();
  var ValPago = document.getElementById("Pago" + cIdCabe).value;
  var lDpto = document.getElementById("DDpto").value;
  var lArea = document.getElementById("DArea").value;
  var lTopa = document.getElementById("PagoValor").value;
  var lSecuen = document.getElementById("DSecuen").value;
  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;
  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      idCabecera: lIdCabe,
      Valor: ValPago,
      dpto: lDpto,
      area: lArea,
      tope: lTopa,
      secuencia: lSecuen
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert(" \n" + lcMsg);
        fnsweetalert("Diccionario de Errores", lcMsg, "error", 1);
      } else {
        var lDeta = document.getElementById("detalle").value;
        lDeta = lDeta.trim();
        document.getElementById("detalle").innerHTML = lDeta + " " + $(dato).find("DesGlosa").text();
        document.getElementById("TotalCxC").value = $(dato).find("Abonado").text();
        document.getElementById("TotPago").value = $(dato).find("Abonado").text();
        fnsweetalert("Preoceso Realizado", "Factura Abonada", "success", 1);
      }

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      //alert('Errro Cancelacion de Facturas CxC');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Factura Abonada');
    }
  })
  return rdata;
}

function fnHabilitaDinero() {
  xasync = false;
  var msgalert, msgerror, msgsistemas;
  var lDine = document.getElementById("TipoDinero").value;

  switch (lDine) {
    case "TJ":
    case "CH":
      document.getElementById("Cheque").disabled = false;
      document.getElementById("TDEntidad").disabled = false;
      document.getElementById("NumCuenta").disabled = false;
      document.getElementById("TDValor").disabled = false;
      break;
    case "DC":
    case "RF":
    case "RI":
      document.getElementById("Cheque").disabled = true;
      document.getElementById("TDEntidad").disabled = true;
      document.getElementById("NumCuenta").disabled = false;
      document.getElementById("TDValor").disabled = false;
      break;
    case "EF":
      document.getElementById("TDValor").disabled = false;
      break;
  }
}

function fnIngresoDinero() {
  var msgalert, msgerror, msgsistemas;
  document.getElementById("DatoCliente").disabled = false;
  document.getElementById("PagoFactura").disabled = false;
  document.getElementById("IngCuentas").disabled = false;
  show_docu1('Dinero');
  hide_docu1('icCtas');
}

// Graba Detalle del Dinero
function fnGrabaDinero() {
  xasync = false;
  var grTabla = "dinero";

  var lTiDi = document.getElementById("TipoDinero").value;
  var lDeFo = document.getElementById("DTDDescrip").value;
  var lCheq = document.getElementById("Cheque").value;
  var lEnti = document.getElementById("TDEntidad").value;
  var lCuen = document.getElementById("NumCuenta").value;
  var lValor = document.getElementById("TDValor").value;
  var lSecuen = document.getElementById("DSecuen").value;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      secuencia: lSecuen,
      Forma: lTiDi,
      Descrip: lDeFo,
      Cheque: lCheq,
      Banco: lEnti,
      Cuenta: lCuen,
      Pago: lValor
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lpagovalor = $(dato).find("TotDinero").text();
      var lPagoValor = new Intl.NumberFormat().format(lpagovalor);
      document.getElementById('PagoValor').value = lPagoValor;
      document.getElementById('DetaDinero').innerHTML = $(dato).find("DetaIngreso").html();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        fnsweetalert("Diccionario de Errores", lcMsg, "error", 1);
      }
      rdata = dato;
      document.getElementById("TipoDinero").value = "";
      document.getElementById("DTDDescrip").value = "";
      document.getElementById("DTEDescrip").value = "";
      document.getElementById("Cheque").value = 0;
      document.getElementById("TDEntidad").value = "";
      document.getElementById("NumCuenta").value = "";
      document.getElementById("TDValor").value = 0.00;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso de Dinero');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Dinero Registrado');
    }
  })
  return rdata;
}

// Calcula Total Dinero Ingreso
function fnTotalDinero(lSecuen) {

  xasync = false;
  var grTabla = "totdinero";

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      secuencia: lSecuen
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);

      var lpagovalor = $(dato).find("TotDinero").text();
      var lPagoValor = new Intl.NumberFormat().format(lpagovalor);

      document.getElementById('PagoValor').value = lPagoValor;
      document.getElementById('Anticipo').value = lpagovalor;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Actualización Dinero');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Total Dinero Actualizado');
    }
  })
  return rdata;
}

function fnEliminaDeta(lOrden, lSecuen, lProceso) {
  xasync = false;
  var grTabla = "elimina";
  var ltabla = "movicuenta"
  var msgalert, msgerror, msgsistemas;
  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      orden: lOrden,
      secuencia: lSecuen,
      tabla: ltabla,
      Proceso: lProceso
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      switch (lProceso) {
        case 1:
          document.getElementById('DetaDinero').innerHTML = $(dato).find("TablaElimina").html();
          break;
        case 2:
          document.getElementById('detall').innerHTML = $(dato).find("TablaElimina").html();
          break;
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Eliminacion de Dinero');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Registro Eliminado');
    }
  })
  return rdata;
}


// Graba CxCDetalle
function fnGrabaCC() {}

function fnCtaProvee() {
  xasync = true;
  var grTabla = "dtMoviCuenta";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('Proveedor').value;
  var lBas0 = document.getElementById('Base0').value;
  var lBasI = document.getElementById('BaseG').value;
  var lBasE = document.getElementById('BaseE').value;
  var lPorI = document.getElementById('Iva').value;
  var lDeta = document.getElementById('detalle').value;
  var lEsta = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lFact = document.getElementById('secuencia').value;

  var lSecu = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      Prove: lCodi,
      base0: lBas0,
      baseG: lBasI,
      baseE: lBasE,
      valIva: lPorI,
      Detalle: lDeta,
      PEst: lEsta,
      PEmi: lEmis,
      PFac: lFact,
      Secuen: lSecu,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //console.log(dato);
      //alert(dato);
      rdata = dato;
      var lFactur = '000000000' + lFact;
      document.getElementById('calIva').value = $(dato).find("valIva").text();
      document.getElementById('calTotal').value = $(dato).find("valTotal").text();
      document.getElementById('calNeto').value = $(dato).find("valNeto").text();
      document.getElementById('secuencia').value = lFactur.substr(-9);
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        //alert("Error : \n" + lcMsg);
        fnsweetalert("Diccionario de Errores", lcMsg, "error", 1);
      } else {
        document.getElementById('detall').innerHTML = $(dato).find("TablaTest").html();
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Calculo de Valores');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Petición realizada');
    }
  })
  return rdata;
}

function fnGrabaProvision() {
  xasync = true;
  var grTabla = "cgcabecera3";
  var prefijo = "cgca_";
  var msgalert, msgerror, msgsistemas;

  var lTcom = document.getElementById('tipoCompro').value;
  var lIdPr = document.getElementById('Proveedor').value;
  var lNoPr = document.getElementById('DPDescrip').value;
  var lfech = document.getElementById('fecha').value;
  var lSust = document.getElementById('Sustento').value;
  var lDeta = document.getElementById('detalle').value;
  var lCred = document.getElementById('Tiempo').value;
  var lTDoc = document.getElementById('TipoDocu').value;
  var lPunt = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lSecu = document.getElementById('secuencia').value;
  var lVenc = document.getElementById('Vence').value;
  var lAuto = document.getElementById('Autoriza').value;
  var lImpr = document.getElementById('Impren').value;
  var lVali = document.getElementById('Valido').value;
  var lBas0 = document.getElementById('Base0').value;
  var lBasG = document.getElementById('BaseG').value;
  var lBasE = document.getElementById('BaseE').value;
  var lPIva = document.getElementById('Iva').value;
  var lRefe = "";
  var lCaja = "";
  var lNChq = "";

  // Valor Radio Buttons
  var lDeIv = document.fDeIva.DevuIva.value;

  var lNSec = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      campo: prefijo,
      tipo: lTcom,
      fecha: lfech,
      detalle: lDeta,
      tiempo: lCred,
      secuencia: lNSec,
      idProve: lIdPr,
      beneficiario: lNoPr,
      sustri: lSust,
      tidocu: lTDoc,
      estab: lPunt,
      emisi: lEmis,
      numfac: lSecu,
      vence: lVenc,
      autori: lAuto,
      impren: lImpr,
      validez: lVali,
      bas0: lBas0,
      basg: lBasG,
      base: lBasE,
      piva: lPIva,
      deiva: lDeIv,
      referen: lRefe,
      CtaCaja: lCaja,
      NumChq: lNChq
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;
      document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Grabacion');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Comprobante Grabado');
    }
  })
  return rdata;
}

// Graba Detalle del Dinero
function fnActivaCtas(lParam) {
  hide_docu1('Dinero');
  show_docu1('icCtas');

  document.getElementById("DCuenta").disabled = false;
  document.getElementById("DGlosa").disabled = false;
  document.getElementById("DDebito").disabled = false;
  document.getElementById("DCredito").disabled = false;
  document.getElementById("DDpto").disabled = false;
  document.getElementById("DArea").disabled = false;
}

function fnGrabaEmpresa() {
  xasync = true;
  var grTabla = "empresa";
  var prefijo = "empr_";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('codigo').value;
  var lDesc = document.getElementById('descrip').value;
  var lAbre = document.getElementById('abrevia').value;
  var lCall = document.getElementById('dircalle').value;
  var lNume = document.getElementById('dirnumero').value;
  var lInte = document.getElementById('dirinter').value;
  var lTele = document.getElementById('telefono').value;
  var lCelu = document.getElementById('celular').value;
  var lCiud = document.getElementById('ciudad').value;
  var lPais = document.getElementById('pais').value;
  var lDpto = document.getElementById('DDpto').value;
  var lArea = document.getElementById('DArea').value;
  var lIVA = document.getElementById('NIva').value;
  var lInic = document.getElementById('anoini').value;
  var lEjer = document.getElementById('anoejer').value;
  var lAcre = document.getElementById('ctaDeudor').value;
  var lDeud = document.getElementById('ctaAcredor').value;
  var lResu = document.getElementById('ctaResulta').value;
  var lUtil = document.getElementById('ctaUtilidad').value;
  var lPerd = document.getElementById('ctaPerdida').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      codigo: lCodi,
      descrip: lDesc,
      tablaGr: grTabla,
      campo: prefijo,
      Abre: lAbre,
      Calle: lCall,
      Nume: lNume,
      Inter: lInte,
      Telefono: lTele,
      Celular: lCelu,
      Ciudad: lCiud,
      Pais: lPais,
      Dpto: lDpto,
      Area: lArea,
      Iva: lIVA,
      Inicio: lInic,
      Ejerci: lEjer,
      Acredo: lAcre,
      Deudor: lDeud,
      Resul: lResu,
      Utilidad: lUtil,
      Perdida: lPerd
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;
      //window.close();
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Actualización de E,presa');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      fnsweetalert("Proceso Terminado", "Datos de Empresa Actualizados", "success", 1)

      //alert('Datos de Empresa Actualizados');
    }
  })
  return rdata;
}

// Facturas CxP por Proveedor
function fnAbonoFactCxP() {
  xasync = false;
  var grTabla = "cpcabecera";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('idProvee').value;
  var lSecu = document.getElementById('DSecuen').value;
  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Proveedor: lCodi,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('pagos').innerHTML = $(dato).find("TablaCxP").html();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Facturas Pendientes');
    }
  })
  return rdata;
}

// Abona Facturas CxP
function fnActualPagoCxP(lIdCabe) {
  var grTabla = "cxpfactura";

  var cIdCabe = lIdCabe.toString();
  var ValPago = document.getElementById("Pago" + cIdCabe).value;
  var lDpto = document.getElementById("DDpto").value;
  var lArea = document.getElementById("DArea").value;
  var lSecuen = document.getElementById("DSecuen").value;
  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      idCabecera: lIdCabe,
      Valor: ValPago,
      dpto: lDpto,
      area: lArea,
      secuencia: lSecuen
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById("detalle").innerHTML = document.getElementById("detalle").value + " " + $(dato).find("DesGlosa").text();
      document.getElementById("TotalCxP").value = $(dato).find("Abonado").text();
      document.getElementById("TotPago").value = $(dato).find("Abonado").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Errro Cancelacion de Facturas CxC');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Factura Abonada');
    }
  })
  return rdata;
}

function fnGrabaCajaEgr() {
  xasync = false;
  var grTabla = "cgcabecera4";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCaja = document.getElementById('CtaCaja').value;
  var lCodi = document.getElementById('idProvee').value;
  var lBene = document.getElementById('DCDescrip').value;
  var lCheq = document.getElementById('numcheque').value;
  var lOpcion = document.getElementById("opIngreso");
  var opSele = lOpcion.value;
  switch (opSele) {
    case 'A':
      grTabla = "cgcabecera4";
      break;
    case 'P':
      grTabla = "cgcabecera5";
      break;
    case 'V':
      grTabla = "cgcabecera";
      break;
  }
  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      CtaCaja: lCaja,
      idProve: lCodi,
      beneficiario: lBene,
      NumChq: lCheq
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;
      var lcMsg = "";
      ltit = "";
      licon = "";

      var lcError = $(dato).find("DesError").text();

      if (lcError.length > 0) {
        lcMsg = lcError.replace(/@/g, "\n");
        //alert(" \n" + lcMsg);
        ltit = "Diccionario de Errores";
        licon = "error";
      } else {
        ltit = "Proceso Terminado";
        lcMsg = "COMPROBANTE DE CAJA ... " + lTipo + " - " + $(dato).find("numdocu").text();
        document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      }
      fnsweetalert(ltit, lcMsg, licon, 1);
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      //alert('Error en Egreso de Caja');
      fnsweetalert("Error en Movimiento", "Comprobante Egreso de Caja", "error", 1);
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Egreso de Caja Grabado');
    }
  })
  return rdata;
}

// Anticipo Proveedores
function fnGrabaAntiCxP() {
  xasync = false;
  var grTabla = "cxpcabecera";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('idProvee').value;
  var lAnti = document.getElementById('Anticipo').value;
  var lSecu = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Cliente: lCodi,
      Antici: lAnti,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lDeta = document.getElementById('DCDescrip').value;
      document.getElementById('DGlosa').value = "ANTICIPO PROVEEDOR " + lDeta;
      document.getElementById('DCuenta').value = $(dato).find("Anticipo").text();
      document.getElementById('DDescrip').value = $(dato).find("Descripcion").text();
      document.getElementById('DDebito').value = document.getElementById('Anticipo').value;
      document.getElementById('detalle').innerHTML = "ANTICIPO PROVEEDOR " + lDeta;
      document.getElementById("Anticipo").disabled = true;
      document.getElementById("DatoCliente").disabled = true;

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Anticipo CXP');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Anticipo a Proveedores');
    }
  })
  return rdata;
}

// Valida que Exista Persona en CxC y CxP
function fnValidaPerso(lthis, lTabla) {
  xasync = false;
  var dbTabla = "";
  var lCamp = "";

  if (lTabla == 1) {
    dbTabla = "cpproveedor";
    lCamp = "cppr_codigo";
  } else {
    dbTabla = "cccliente";
    lCamp = "cccl_codigo";
  }

  var grTabla = "identifica";
  var lIden = lthis.value;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Idente: lIden,
      tablaGr: grTabla,
      Tabla: dbTabla,
      dbCampo: lCamp
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lExiste = $(dato).find("Creado").text();
      if (lExiste === "NO EXISTE")
        document.getElementById("DCDescrip").disabled = false;
      else
        document.getElementById("DCDescrip").disabled = true;

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Validacion de Identificacion');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Idenificacion Validad');
    }
  })
  return rdata;
}

// Valida que el Cli-Prov 
// Varios Exista
function fnValidaCliPro(lthis) {

  xasync = false;
  var grTabla = "exclieprov";
  var lIden = lthis.value;
  var lOpcion = document.getElementById("opIngreso");

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Idente: lIden,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      if (lOpcion === "A") {
        var lExiste = $(dato).find("ClieProv").text();
        document.getElementById("DCDescrip").value = lExiste;
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Clie-Prov');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      if (lOpcion === "A") {
        alert('Correcto CLIE-PROV');
      }
    }
  })
  return rdata;
}

// Graba en la Tabla CliePro
// Cedulas Varias
function fnGrabaCliPro(lIden, lNomb) {

  xasync = false;
  var grTabla = "clieprov";
  var lCodi = lIden.value;
  var lDesc = lNomb.value;
  var lTipo = document.getElementById('tipoCompro').value;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      TipoComp: lTipo,
      Idente: lCodi,
      Persona: lDesc,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Clie-Prov');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Correcto CLIE-PROV');
    }
  })
  return rdata;
}

// Secuencia de Cheque 
// segun el Banco
function fnSecuenciaChq(lthis) {
  xasync = false;
  var grTabla = "secuchq";
  var lBanco = lthis.value;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      banco: lBanco,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lSigChq = $(dato).find("NumCheque").text();
      document.getElementById("numcheque").value = lSigChq;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Secuencia de Cheque');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Correcto CLIE-PROV');
    }
  })
  return rdata;
}


// Consulta de Comprobantes
function fnConsultaCompro(lCabecera) {
  xasync = false;
  var lIdCa = lCabecera;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../General/gnConDiario.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      idcabecera: lIdCa
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error Secuencia de Cheque');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Correcto CLIE-PROV');
    }
  })
  return rdata;
}

// Reporte General Contable
function fnMuestraInfo(reporte) {

  xasync = false;
  var grTabla = "cgReporte";
  var msgalert, msgerror, msgsistemas;

  var lCueD = document.getElementById('CuentaD').value;
  var lCueH = document.getElementById('CuentaH').value;
  var lDpto = document.getElementById('Dpto').value;
  var lArea = document.getElementById('Area').value;
  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;
  var lTipo = document.getElementById('tipoCompro').value;
  var lNumI = document.getElementById('numComproI').value;
  var lNumF = document.getElementById('numComproF').value;
  var lRepo = document.getElementById('Reporte').value;
  var lResu = document.getElementById("chkResumen").checked;
  var lTiRe = reporte;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      ctaDesde: lCueD,
      ctaHasta: lCueH,
      dpto: lDpto,
      area: lArea,
      desde: lDesd,
      hasta: lHast,
      TipoC: lTipo,
      numIni: lNumI,
      numFin: lNumF,
      TipoMovi: lRepo,
      Resu: lResu,
      Reporte: lTiRe,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //console.log(dato);
      //alert(dato);
      if (reporte == 0) {
        fnsweetalert("Proceso Terminado", "Movimiento Contable", "success", 2, "tDetalle", dato);
        //document.getElementById('tDetalle').innerHTML = dato;
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Movimiento Contable');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Movimiento Contable');
    }
  })
  return rdata;
}

// Reporte de Balances
function fnBalances() {
  xasync = false;
  var grTabla = "cgSituaFinan";
  var msgalert, msgerror, msgsistemas;

  var lAnio = document.getElementById('Anio').value;
  var lMesr = document.getElementById('Mes').value;
  var lNive = document.getElementById('Nivel').value;
  var lDpto = document.getElementById('Dpto').value;
  var lArea = document.getElementById('Area').value;
  var lRepo = document.getElementById("opReporte").value;
  var lMesn = document.getElementById("Mes");
  var lMesT = lMesn.options[lMesn.selectedIndex].text;
  var lAcum = document.getElementById("Acum");
  var lValC = lAcum.options[lAcum.selectedIndex].value;
  var lDesd = document.getElementById("Desde").value;
  var lHast = document.getElementById("Hasta").value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      anio: lAnio,
      mes: lMesr,
      nivel: lNive,
      mest: lMesT,
      dpto: lDpto,
      area: lArea,
      Repo: lRepo,
      Acumula: lValC,
      Desde: lDesd,
      Hasta: lHast,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      ///console.log(dato);
      fnsweetalert("Proceso Terminado", "Balance Generado", "success", 2, "Balance", dato);
      //document.getElementById('Balance').innerHTML = dato;

    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Balances');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Balance Generado...');
    }
  })
  return rdata;
}

// Reporte Balance de Comprobacion
function fnMuestraInfo2() {
  xasync = false;
  var grTabla = "cgComproba";
  var msgalert, msgerror, msgsistemas;

  var lCueD = document.getElementById('CuentaD').value;
  var lCueH = document.getElementById('CuentaH').value;
  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      ctaDesde: lCueD,
      ctaHasta: lCueH,
      desde: lDesd,
      hasta: lHast,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      fnsweetalert("Proceso Terminado", "Balance de Comprobación", "success", 2, "tDetalle", dato)
      //document.getElementById('tDetalle').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Movimiento Contable');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Movimiento Contable');
    }
  })
  return rdata;
}

// Saldos Bancarios
function fnMuestraInfo3() {
  xasync = false;
  var grTabla = "cbBanco";
  var msgalert, msgerror, msgsistemas;

  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  hide_docu1('cCheque');
  hide_docu1('cEstaCta');

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      desde: lDesd,
      hasta: lHast,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('tDetalle').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Flujo de Efectivo');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Flujo de Efectivo');
    }
  })
  return rdata;
}

// Saldos Bancarios
function fnSaldoBanco() {
  xasync = false;
  var grTabla = "cbBanco";
  var msgalert, msgerror, msgsistemas;

  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      desde: lDesd,
      hasta: lHast,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('tDetalle').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Saldos Bancarios');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Saldos Bancarios');
    }
  })
  return rdata;
}

// Estado de Cuenta Caja-Bancos
function fnMuestraDatos(lImpre) {
  xasync = false;
  var grTabla = "cgEstaCuenta";
  var msgalert, msgerror, msgsistemas;

  var lCuen = document.getElementById('Cuenta').value;
  var lDpto = document.getElementById('Dpto').value;
  var lArea = document.getElementById('Area').value;
  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;
  var lRepo = document.getElementById('Reporte').value;
  var lTico = document.getElementById('tipoCompro').value;
  var lNumI = document.getElementById('numComproI').value;
  var lNumF = document.getElementById('numComproF').value;
  var Impri = lImpre;
  var lReca = '';

  if (lRepo === 'CB')
    lReca = document.getElementById('idRecauda').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      cuenta: lCuen,
      dpto: lDpto,
      area: lArea,
      desde: lDesd,
      hasta: lHast,
      Recau: lReca,
      Compr: lTico,
      NumeI: lNumI,
      NumeF: lNumF,
      Imprim: Impri,
      TipoMovi: lRepo,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      //document.getElementById('tDetalle').innerHTML = dato;
      fnsweetalert("Proceso Terminado", "Estado de Cuenta Generado", "success", 2, 'tDetalle', dato);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      //alert('Disculpe, existi� un problema');
      fnsweetalert("Error en Proceso", "", "error", 1);
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Consulta Realizada');
    }
  })
  return rdata;
}

// Estado de Cuenta Caja-Bancos 
// Desde otra Funcion
function fnMuestraDatos2(lCuenta) {
  xasync = false;
  var grTabla = "cgEstaCuenta";
  var msgalert, msgerror, msgsistemas;
  var lCuen = lCuenta;
  var lDpto = document.getElementById('Dpto').value;
  var lArea = document.getElementById('Area').value;
  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;
  var lRepo = document.getElementById('Reporte').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;
  show_docu1("cEstaCta");

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      cuenta: lCuen,
      dpto: lDpto,
      area: lArea,
      desde: lDesd,
      hasta: lHast,
      TipoMovi: lRepo,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('tSaldos').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error LLamado Estado de Cuenta');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Estado de Cuenta Realizada');
    }
  })
  return rdata;
}

// Listado de Cheques Especifico
function fnMuestraDatos3(lCuenta) {
  xasync = false;
  var grTabla = "cbCheque";
  var msgalert, msgerror, msgsistemas;
  var lCuen = lCuenta;
  var lBcos = document.getElementById('Banco').value;
  var lDesd = document.getElementById('Desde').value;
  var lHast = document.getElementById('Hasta').value;
  var lOpcion = document.getElementById("opCheque");
  var opSele = lOpcion.value;

  var scrip = '../Libreria/libreria.php';
  show_docu1('cCheque');
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      cuenta: lCuen,
      banco: lBcos,
      desde: lDesd,
      hasta: lHast,
      Estado: opSele,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      fnsweetalert("Proceso Terminado", "Generacion Exitosa", "success", 2, 'tCheques', dato);
      //document.getElementById('tCheques').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Listado de Cheques');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Cheques Terminado');
    }
  })
  return rdata;
}


// Listado de Cheques Especifico
function fnMarcaCheque(lIdCabe, lTipo) {
  xasync = false;
  var grTabla = "MarcaCheque";
  var msgalert, msgerror, msgsistemas;
  var lIdCa = lIdCabe;
  var lAcc = lTipo;
  var lFech = document.getElementById('entrega' + lIdCa).value;

  var scrip = '../Libreria/libreria.php';
  var lTit = '';
  var lIco = '';
  var lcMsg = '';
  document.body.style.cursor = 'progress';
  var rdata;

  if (lAcc === 1)
    lcMsg = 'Cheque Procesado';
  else
    lcMsg = 'Movimiento Conciliado';

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      idcabecera: lIdCa,
      Tipo: lAcc,
      fchMarca: lFech,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //console.log(dato);
      //alert(dato);
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        lcMsg = lcError.replace(/@/g, "\n");
        //alert("Diccionario de Errores \n" + lcMsg);
        lTit = "Erro en Proceso";
        lico = "error";
      } else {
        lTit = "Proceso Correcto";
        lico = "success";
      }
      fnsweetalert(lTit, lcMsg, lico, 1);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Entrega de Cheques');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Cheque Registrado');
    }
  })
  return rdata;
}

// Saldo de Entidades
// CxC y CxP
function fnSaldoEntidad() {
  xasync = false;
  var grTabla = "EntidadCx";
  var msgalert, msgerror, msgsistemas;
  var lFech = document.getElementById('Hasta').value;
  var lEntid = document.getElementById("opEntidad");
  var opEnti = lEntid.value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      fchSaldo: lFech,
      TipoTab: opEnti,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      document.getElementById('tEntidad').innerHTML = dato;
      show_docu1("Deta");

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Saldo Entidad CXP');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Consulta Realizada');
    }
  })
  return rdata;
}


function fnMoviEntidad(lidEntidad, lTipo) {
  xasync = false;
  var grTabla = "DetalleCx";
  var msgalert, msgerror, msgsistemas;
  var lInic = document.getElementById('Desde').value;
  var lFech = document.getElementById('Hasta').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      lIdent: lidEntidad,
      fchInicio: lInic,
      fchSaldo: lFech,
      TipoTab: lTipo,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      document.getElementById('tResumen').innerHTML = $(dato).find("Resumen").html();
      document.getElementById('tEstCta').innerHTML = $(dato).find("DetaEnti").html();
      show_docu1("Docu");
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Saldo Entidad CXP');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Consulta Realizada');
    }
  })
  return rdata;
}

function fnEstCtaEntidad() {
  xasync = true;
  var grTabla = "EstaCx";
  var msgalert, msgerror, msgsistemas;
  var lidEn = document.getElementById('persona').value;
  var lInic = document.getElementById('Desde').value;
  var lFech = document.getElementById('Hasta').value;
  var lEntid = document.getElementById("opEntidad");
  var opEnti = lEntid.value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      lIdent: lidEn,
      fchInicio: lInic,
      fchSaldo: lFech,
      TipoTab: opEnti,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      document.getElementById('tEstCta').innerHTML = $(dato).find("DetaEnti").html();
      show_docu1("Docu");
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Saldo Entidad CXP');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Consulta Realizada');
    }
  })
  return rdata;
}

// Resumen General de Entidades
// CxC y CxP
function fnResGenEntidad() {
  xasync = false;
  var grTabla = "ResGenCx";
  var msgalert, msgerror, msgsistemas;

  var lIdPe = document.getElementById('persona').value;
  var lHast = document.getElementById('Hasta').value;
  var lEnti = document.getElementById("opEntidad");
  var opEnt = lEnti.value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      lIdent: lIdPe,
      fchSaldo: lHast,
      TipoTab: opEnt,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('tDetalle').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Disculpe, existi� un problema');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Consulta Realizada');
    }
  })
  return rdata;
}


// Edad de Entidades
// CxC y CxP
function fnEdadCartera() {
  xasync = false;
  var grTabla = "EdadCx";
  var msgalert, msgerror, msgsistemas;

  var lHast = document.getElementById('Hasta').value;
  var lEnti = document.getElementById("opEntidad");
  var opEnt = lEnti.value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      fchSaldo: lHast,
      TipoTab: opEnt,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('tDetalle').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Disculpe, existi� un problema');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Consulta Realizada');
    }
  })
  return rdata;
}

function fnGrabaReten() {
  xasync = false;
  var grTabla = "rdinero";

  var lIdcl = document.getElementById("idCliente").value;
  var lTiDi = document.getElementById("TipoDinero").value;
  var lDeFo = document.getElementById("DTDDescrip").value;
  var lBase = document.getElementById("BaseRet").value;
  var lRete = document.getElementById("PorRet").value;
  var lCodF = document.getElementById("ConRetF").value;
  var lCodI = document.getElementById("ConRetI").value;
  var lRest = document.getElementById('restable').value;
  var lResn = document.getElementById('remision').value;
  var lNumr = document.getElementById('rsecuencia').value;
  var lFest = document.getElementById('festable').value;
  var lFesn = document.getElementById('femision').value;
  var lFact = document.getElementById('fsecuencia').value;
  var lSecuen = document.getElementById("DSecuen").value;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      secuencia: lSecuen,
      Idclie: lIdcl,
      Forma: lTiDi,
      Descrip: lDeFo,
      Base: lBase,
      Porce: lRete,
      CodF: lCodF,
      CodI: lCodI,
      Resta: lRest,
      Remisi: lResn,
      Reten: lNumr,
      Festa: lFest,
      Femisi: lFesn,
      Fact: lFact
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('PagoValor').value = $(dato).find("TotDinero").text();
      document.getElementById('DetaDinero').innerHTML = $(dato).find("DetaIngreso").html();
      var lcError = $(dato).find("DesError").text();
      var lcMsg = lcError.replace(/@/g, "\n");

      if (lcError.length > 0) {
        fnsweetalert("Dicionario de Errores", lcMsg, "error", 1);
      } else {
        fnsweetalert("Proceso Correcto", "Informacion Ingresada", "success", 1);
      }
      rdata = dato;
      document.getElementById("TipoDinero").value = "";
      document.getElementById("DTDDescrip").value = "";
      document.getElementById("BaseRet").value = 0.00;
      document.getElementById("PorRet").value = 0.00;
      document.getElementById("ValorRet").value = 0.00;
      document.getElementById("ConRetI").value = "";
      document.getElementById("ConRetF").value = "";
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso de Retención');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Retención Valida');
    }
  })
  return rdata;
}

function fnValRet() {
  xasync = false;
  var grTabla = "RetenCxC";

  var lidcl = document.getElementById("idCliente").value;
  var lNomb = document.getElementById("DCDescrip").value;
  var lrest = document.getElementById("restable").value;
  var lremi = document.getElementById("remision").value;
  var lrete = document.getElementById("rsecuencia").value;
  var lfest = document.getElementById("festable").value;
  var lfemi = document.getElementById("femision").value;
  var lfact = document.getElementById("fsecuencia").value;

  var msgalert, msgerror, msgsistemas;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      idCliente: lidcl,
      Restable: lrest,
      Remision: lremi,
      Reten: lrete,
      Festable: lfest,
      Femision: lfemi,
      Factur: lfact,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      var lcReten = $(dato).find("NumReten").text();
      document.getElementById("restable").value = lcReten.substr(0, 3);
      document.getElementById("remision").value = lcReten.substr(4, 3);
      document.getElementById("rsecuencia").value = lcReten.substr(-9);

      var lcfactu = $(dato).find("NumFactu").text();
      document.getElementById("festable").value = lcfactu.substr(0, 3);
      document.getElementById("femision").value = lcfactu.substr(4, 3);
      document.getElementById("fsecuencia").value = lcfactu.substr(-9);

      var lcDeta = "CLIENTE: " + lNomb.substr(0, 20) + " ABONA FACT: " + lcfactu + " CON RETENCION: " + lcReten;
      document.getElementById("detalle").innerHTML = lcDeta;
      document.getElementById("guardar").disabled = false;

      var lcError = $(dato).find("DesError").text();
      var lcMsg = lcError.replace(/@/g, "\n");

      if (lcError.length > 0) {
        fnsweetalert("Dicionario de Errores", lcMsg, "error", 1);
        document.getElementById("guardar").disabled = true;
      } else {
        fnsweetalert("Validacion Correcta", "Datos Validados", "success", 1);
      }

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso de Retención');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Retención Registrada');
    }
  })
  return rdata;
}

// Ingreso por Retencion CxC
function fnGrabaCajaRet() {
  xasync = false;
  var grTabla = "cgcabecera6";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCaja = document.getElementById('CtaCaja').value;
  var lCodi = document.getElementById('idCliente').value;
  var lBene = document.getElementById('DCDescrip').value;
  var lRest = document.getElementById('restable').value;
  var lResn = document.getElementById('remision').value;
  var lRete = document.getElementById('rsecuencia').value;
  var lAuto = document.getElementById('autoRet').value;
  var lFest = document.getElementById('festable').value;
  var lFesn = document.getElementById('femision').value;
  var lFact = document.getElementById('fsecuencia').value;
  var lValo = document.getElementById('PagoValor').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      CtaCaja: lCaja,
      idProve: lCodi,
      beneficiario: lBene,
      NumChq: 0,
      ValDin: lValo,
      REsta: lRest,
      REsmi: lResn,
      Reten: lRete,
      FEsta: lFest,
      FEmis: lFesn,
      Factur: lFact,
      Rauto: lAuto
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      rdata = dato;
      document.getElementById('numCompro').value = $(dato).find("numdocu").text();
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Ingreso a Caja Grabado');
    }
  })
  return rdata;
}

// Ingreso por Retencion CxC
function fnGrabaDocCxC() {
  xasync = false;
  var grTabla = "DocumCx";
  var msgalert, msgerror, msgsistemas;
  var lIdCa = document.getElementById('IdCabe').value;
  var lNuCo = document.getElementById('numCompro').value;
  var lTipo = document.getElementById('tipoCompro').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCodi = document.getElementById('idPerso').value;
  var lBene = document.getElementById('DCDescrip').value;
  var lCtas = document.getElementById('DCuenta').value;
  var lValo = document.getElementById('TotalCxC').value;
  var lPlaz = document.getElementById('plazo').value;
  var lDocu = document.getElementById('TipoDocu').value;
  var lEsta = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lFact = document.getElementById('factura').value;
  var lDpto = document.getElementById('DDpto').value;
  var lArea = document.getElementById('DArea').value;
  var lModu = document.getElementById('modulo').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      idCabe: lIdCa,
      tipo: lTipo,
      numcom: lNuCo,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      idPerso: lCodi,
      nomClie: lBene,
      deuda: lValo,
      cuenta: lCtas,
      Dias: lPlaz,
      Dpto: lDpto,
      Area: lArea,
      TipoDocu: lDocu,
      Esta: lEsta,
      Emis: lEmis,
      Fact: lFact,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Creacion de Documento');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Docmuento Grabado');
    }
  })
  return rdata;
}

// Valido que la Factura no Exista
function fnValFac() {
  xasync = false;
  var grTabla = "OtrFact";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lCodi = document.getElementById('idPerso').value;
  var lEsta = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lFact = document.getElementById('factura').value;
  var lModu = document.getElementById('modulo').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      Tipo: lTipo,
      idPerso: lCodi,
      Esta: lEsta,
      Emis: lEmis,
      Factu: lFact,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      document.getElementById("guardar").disabled = false;
      console.log(dato);
      //alert(dato);

      var lcFactur = $(dato).find("NumFact").text();
      document.getElementById("estable").value = lcFactur.substr(0, 3);
      document.getElementById("emision").value = lcFactur.substr(4, 3);
      document.getElementById("factura").value = lcFactur.substr(-9);

      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
        document.getElementById("guardar").disabled = true;
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Documento no Existe');
    }
  })
  return rdata;
}

// Muestra los Documentos por Cancelar
function fnMuestraPagos() {
  xasync = false;
  var grTabla = "OtroPago";
  var msgalert, msgerror, msgsistemas;

  var lTiCo = "FA";
  var lTipo = document.getElementById('tipoCompro').value;
  var lCodi = document.getElementById('idPerso').value;
  var lFIni = document.getElementById('fchDesde').value;
  var lFFin = document.getElementById('fchHasta').value;
  var lNIni = document.getElementById('numDesde').value;
  var lNFin = document.getElementById('numHasta').value;

  var lEsta = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lFact = document.getElementById('factura').value;
  var lModu = document.getElementById('modulo').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      Tipo: lTipo,
      Docu: lTiCo,
      idPerso: lCodi,
      Fini: lFIni,
      Ffin: lFFin,
      Nini: lNIni,
      Nfin: lNFin,
      Esta: lEsta,
      Emis: lEmis,
      Factu: lFact,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      document.getElementById("Listado").innerHTML = $(dato).find("TablaReporte").html();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Consulta Realizada');
    }
  })
  return rdata;
}

// Pagos Otros Documentos Cx
function fnGrabaPagoCxC() {
  xasync = false;
  var grTabla = "PagoCx";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCodi = document.getElementById('idPerso').value;
  var lNomb = document.getElementById('DCDescrip').value;
  var lValo = document.getElementById('Pago').value;
  var lCtas = document.getElementById('DCuenta').value;
  var lIdCa = document.getElementById('idcabecera').value;
  var lDpto = document.getElementById('DDpto').value;
  var lArea = document.getElementById('DArea').value;
  var lModu = document.getElementById('modulo').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      idPerso: lCodi,
      NomPer: lNomb,
      cuenta: lCtas,
      valor: lValo,
      idCabe: lIdCa,
      Dpto: lDpto,
      Area: lArea,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Docmuento Grabado');
    }
  })
  return rdata;
}

// Pagos Otros Documentos Cx
function fnSubeArchivoXML() {
  xasync = false;
  var grTabla = "ArchivoXML";
  var msgalert, msgerror, msgsistemas;
  var lArchivo = document.getElementById('fileXML').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      archivo: lArchivo,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      alert(dato);
      //document.getElementById('FileXML').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Docmuento Grabado');
    }
  })
  return rdata;
}

// Nota de Credito CXP
function fnDatoProvi() {
  xasync = false;
  var grTabla = "DatoProv";
  var msgalert, msgerror, msgsistemas;
  var lidPe = document.getElementById('Proveedor').value;
  var lEsta = document.getElementById('estable').value;
  var lEmis = document.getElementById('emision').value;
  var lFact = document.getElementById('secuencia').value;

  var scrip = '../Libreria/libreria.php';

  lEsta = '000' + lEsta;
  lEsta = lEsta.substr(-3);
  lEmis = '000' + lEmis;
  lEmis = lEmis.substr(-3);
  lFact = '000000000' + lFact;
  lFact = lFact.substr(-9);

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      idPerso: lidPe,
      esta: lEsta,
      emis: lEmis,
      fact: lFact,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      console.log(dato);
      //alert(dato) ;
      document.getElementById('numProvi').value = $(dato).find("Provis").text();
      var lValor0 = $(dato).find("base0").text();
      var lValorG = $(dato).find("baseg").text();
      var lValorX = $(dato).find("basex").text();
      var lPorcen = $(dato).find("valiva").text();
      var lValorN = $(dato).find("valtot").text();
      var lCalIva = $(dato).find("caliva").text();
      var lSaldo = $(dato).find("saldo").text();

      document.getElementById('Base0').value = lValor0;
      document.getElementById('BaseG').value = lValorG;
      document.getElementById('BaseE').value = lValorX;
      document.getElementById('Iva').value = lPorcen;
      document.getElementById('calIva').value = lCalIva;
      document.getElementById('calTotal').value = lValorN;
      document.getElementById('calNeto').value = lSaldo;
      document.getElementById('calNC').value = lValorN;
      document.getElementById('ValNC').value = lValorN;

      document.getElementById('estable').value = lEsta;
      document.getElementById('emision').value = lEmis;
      document.getElementById('secuencia').value = lFact;

      if ((lValor0 + lValorG + lValorX + lCalIva) >= 0) {
        alert("Proveedor Factura no Existe : " + lEsta + "-" + lEmis + "-" + lFact);
        document.getElementById('guardar').disabled = true;
      } else {
        alert("Proveedor Factura Correcta : " + lEsta + "-" + lEmis + "-" + lFact);
        document.getElementById('guardar').disabled = false;
      }

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Nota de Credito Proveedor');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //		alert('Docmuento Grabado');
    }
  })
  return rdata;
}

// Notas de Credito CxP
function fnGrabaNCCxP() {
  xasync = false;
  var grTabla = "NCCx";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('tipoCompro').value;
  var lRefe = document.getElementById('referen').value;
  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCodi = document.getElementById('idPerso').value;
  var lNomb = document.getElementById('DCDescrip').value;
  var lValo = document.getElementById('TipoDocu').value;
  var lFest = document.getElementById('estable').value;
  var lFemi = document.getElementById('emision').value;
  var lFsec = document.getElementById('secuencia').value;
  var lNest = document.getElementById('ncestable').value;
  var lNemi = document.getElementById('ncemision').value;
  var lNsec = document.getElementById('ncsecuencia').value;
  var lNaut = document.getElementById('autoriza').value;
  var lNfem = document.getElementById('vence').value;
  var lNfva = document.getElementById('valido').value;
  var lNba0 = document.getElementById('Base0').value;
  var lNbag = document.getElementById('BaseG').value;
  var lNbae = document.getElementById('BaseE').value;


  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      idPerso: lCodi,
      NomPer: lNomb,
      cuenta: lCtas,
      valor: lValo,
      idCabe: lIdCa,
      Dpto: lDpto,
      Area: lArea,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      document.getElementById('numCompro').value = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Docmuento Grabado');
    }
  })
  return rdata;
}

// Graba Persona
function fnGrabaPersona() {
  xasync = true;
  var msgalert, msgerror, msgsistemas;


  var grTabla = document.getElementById('dbTabla').value;
  var prefijo = document.getElementById('dbPrefi').value;
  var dbCondi = document.getElementById('dbPerfil').value;

  var lCodi = document.getElementById('codigo').value;
  var lApe1 = document.getElementById('apell1').value;
  var lApe2 = document.getElementById('apell2').value;
  var lNom1 = document.getElementById('nomb1').value;
  var lNom2 = document.getElementById('nomb2').value;
  var lFech = document.getElementById('fecha').value;
  var lPais = document.getElementById('Pais').value;
  var lSang = document.getElementById('sangre').value;
  var lCall = document.getElementById('calle').value;
  var lNume = document.getElementById('numero').value;
  var lInte = document.getElementById('inter').value;
  var lTele = document.getElementById('telefono').value;
  var lCelu = document.getElementById('celular').value;
  var lCivi = document.getElementById('civil').value;
  var lHijo = document.getElementById('hijos').value;
  var lTitu = document.getElementById('titulo').value;
  var lEmai = document.getElementById('email').value;
  var lCont = document.getElementById('contacto').value;
  var lReem = document.getElementById('reemplazo').value;
  var lPoDi = document.getElementById('pordis').value;

  var lOpci1 = document.getElementById("opIdPe");
  var opIdPe = lOpci1.value;

  var lOpci2 = document.getElementById("opSexo");
  var opSexo = lOpci2.value;

  var lOpci3 = document.getElementById("opProfe");
  var opProf = lOpci3.value;

  var lOpci4 = document.getElementById("opRela");
  var opRela = lOpci4.value;

  var lOpci5 = document.getElementById("opDisca");
  var opDisc = lOpci5.value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      campo: prefijo,
      condicion: dbCondi,
      codigo: lCodi,
      apellido1: lApe1,
      apellido2: lApe2,
      nombre1: lNom1,
      nombre2: lNom2,
      fecha: lFech,
      pais: lPais,
      sangre: lSang,
      calle: lCall,
      numero: lNume,
      inter: lInte,
      telefono: lTele,
      celular: lCelu,
      civil: lCivi,
      hijo: lHijo,
      titulo: lTitu,
      email: lEmai,
      contacto: lCont,
      reemplaza: lReem,
      pordisca: lPoDi,
      tipodocu: opIdPe,
      sexo: opSexo,
      profe: opProf,
      relacion: opRela,
      discapa: opDisc
    },

    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;

    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Grabación de Personal');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Personal Grabado...' + lCodi);
    }
  })
  return rdata;
}

// Graba Empleado
function fnGrabaEmpleado() {
  xasync = true;
  var msgalert, msgerror, msgsistemas;


  var grTabla = document.getElementById('dbTabla').value;
  var prefijo = document.getElementById('dbPrefi').value;
  var dbCondi = document.getElementById('dbPerfil').value;

  var lCodi = document.getElementById('codigo').value;
  var lIngr = document.getElementById('fecha').value;
  var lCias = document.getElementById('cia').value;
  var lSuel = document.getElementById('sueldo').value;
  var lCont = document.getElementById('contra').value;
  var lCarg = document.getElementById('cargo').value;
  var lTurn = document.getElementById('turno').value;
  var lSect = document.getElementById('sector').value;
  var lDpto = document.getElementById('DDpto').value;
  var lArea = document.getElementById('DArea').value;
  var lBanc = document.getElementById('TDEntidad').value;
  var lNumc = document.getElementById('numcta').value;

  var lOpci1 = document.getElementById("opEsta");
  var opEsta = lOpci1.value;

  var lHextr = document.fExtra.HoraExtra.value;

  var lOpci2 = document.getElementById("opFoPa");
  var opPago = lOpci2.value;

  var lOpci3 = document.getElementById("opTiCu");
  var opTiCu = lOpci3.value;

  var lOpci4 = document.getElementById("opFoRe");
  var opFoRe = lOpci4.value;

  var lOpci5 = document.getElementById("opMaTa");
  var opMaTa = lOpci5.value;

  var lOpci6 = document.getElementById("opFoPa");
  var opFoPa = lOpci6.value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      campo: prefijo,
      condicion: dbCondi,

      codigo: lCodi,
      ingreso: lIngr,
      empre: lCias,
      sueldo: lSuel,
      contrato: lCont,
      cargo: lCarg,
      turno: lTurn,
      sectorial: lSect,
      dpto: lDpto,
      area: lArea,
      banco: lBanc,
      numcta: lNumc,
      estado: opEsta,
      horaex: lHextr,
      forpago: opPago,
      tipocuen: opTiCu,
      fondo: opFoRe,
      tarje: opMaTa,
      tipopago: opFoPa
    },

    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      rdata = dato;

    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Grabación de Empleado');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Empleado Grabado...' + lCodi);
    }
  })
  return rdata;
}

// Proesos Nominas
function fnProceNomi() {
  xasync = false;
  var grTabla = "noProceso";
  var msgalert, msgerror, msgsistemas;

  var lDesd = document.getElementById('fechad').value;
  var lHast = document.getElementById('fechah').value;
  var lAnio = document.getElementById('anio').value;
  var lDpto = document.getElementById('Dpto').value;
  var lArea = document.getElementById('Area').value;
  var lCodi = document.getElementById('codigo').value;

  var lOpci1 = document.getElementById("opMes");
  var opMes = lOpci1.value;

  var lOpci2 = document.getElementById("opTar");
  var opTar = lOpci2.value;

  var lOpci3 = document.getElementById("opQui");
  var opQui = lOpci3.value;

  var lOpci4 = document.getElementById("opCal");
  var opCal = lOpci4.value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      desde: lDesd,
      hasta: lHast,
      anio: lAnio,
      dpto: lDpto,
      area: lArea,
      pers: lCodi,
      mes: opMes,
      tar: opTar,
      qui: opQui,
      cal: opCal,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('Nomina').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Movimiento Contable');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Movimiento Contable');
    }
  })
  return rdata;
}

// Parametros Nominas
function fnParaNomi() {
  xasync = false;
  var grTabla = "noparame";
  var msgalert, msgerror, msgsistemas;

  var lIden = document.getElementById('ruc').value;
  var lSuel = document.getElementById('sueldo').value;
  var lQuin = document.getElementById('quince').value;
  var lNavi = document.getElementById('bonon').value;
  var lEsco = document.getElementById('bonoe').value;
  var lFond = document.getElementById('fondo').value;
  var lPies = document.getElementById('piess').value;
  var lPpat = document.getElementById('ppatron').value;

  var lHe25 = document.getElementById('he25').value;
  var lHe50 = document.getElementById('he50').value;
  var lHe10 = document.getElementById('he10').value;
  var lAnpa = document.getElementById('antpag').value;
  var lIess = document.getElementById('iess').value;
  var lRent = document.getElementById('renta').value;
  var lAtra = document.getElementById('atraso').value;
  var lDiai = document.getElementById('diai').value;
  var lDiaf = document.getElementById('diaf').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      ruc: lIden,
      nosu: lSuel,
      noqu: lQuin,
      nona: lNavi,
      noes: lEsco,
      nofo: lFond,
      no25: lHe25,
      no50: lHe50,
      no10: lHe10,
      noap: lAnpa,
      noie: lIess,
      nore: lRent,
      noat: lAtra,
      diai: lDiai,
      diaf: lDiaf,
      pies: lPies,
      ppat: lPpat,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('Nomina').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Movimiento Contable');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Movimiento Contable');
    }
  })
  return rdata;
}

function fnGrabaJutifica() {
  xasync = true;
  var grTabla = "nojustifica";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('codigo').value;
  var lfech = document.getElementById('fecha').value;
  var lperm = document.getElementById('tipoper').value;
  var lDdes = document.getElementById('ddesde').value;
  var lDhas = document.getElementById('dhasta').value;
  var lHdes = document.getElementById('hdesde').value;
  var lHhas = document.getElementById('hhasta').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      codigo: lCodi,
      fecha: lfech,
      permi: lperm,
      ddesde: lDdes,
      dhasta: lDhas,
      hdesde: lHdes,
      hhasta: lHhas,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {

    },
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      document.getElementById('Justifica').innerHTML = dato;
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Disculpe, existi� un problema');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Petici�n realizada');
    }
  })
  return rdata;
}

function fnImprDocu() {

  xasync = true;
  var grTabla = "ImprimeDocu";
  var msgalert, msgerror, msgsistemas;

  var lDocu = document.getElementById('tipoCompro').value;
  var lNume = document.getElementById('numCompro').value;
  var lRuta = "../General/gnImprDocu.php?docu=" + lDocu + "&nume=" + lNume;
  window.open(lRuta, "_blank");

}

// Valida que exista un codigo en una tabla
function fnLocalCodigo() {
  xasync = true;
  var grTabla = "buscarCodigo";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('codigo').value;
  var lTabl = document.getElementById('dbTabla').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      codigo: lCodi,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {

    },
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //             alert(dato);
      console.log(dato);
      var lExis = $(dato).find("Existe").text();
      rdata = dato;
      var linea = window.location.href;
      if (lExis == 1)
        window.location.href = linea + "?keyCta=" + lCodi;


      //               var linea = window.location.hostname ;
      //               alert( "hostname => " + linea) ;
      //               var linea = window.location.pathname ;
      //               alert( "pathname => " + linea) ;
      //               var linea = window.location.protocol ;
      //               alert( "protocol => " + linea) ;
      //               var linea = window.location.origin ;
      //               alert( "origin => " + linea) ;
      //               var linea = window.location.href ;
      //               alert( "href => " + linea) ;
      //               var linea = window.location.search ;
      //               alert( "href => " + linea) ;


      //               if (lExis == 1)
      //                 {
      //                    if (lTabl == 'cccliente')
      //                       {
      //                        window.location.href="https://expertodb.vcrxol.com/CxC/ccMntCliente.php?keyCta="+ lCodi;
      //                       }
      //                    else
      //                       {
      //                         window.location.href="https://expertodb.vcrxol.com/CxP/cpMntProveedor.php?keyCta="+ lCodi;    
      //                       }
      //                 }

    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Disculpe, existi� un problema');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Petici�n realizada');
    }
  })

  //   window.location.hostname:  Devuelve el nombre de host de la URL (por ejemplo, "expertodb.vcrxol.com/"). 
  //   window.location.pathname:  Devuelve la parte de la ruta de la URL (por ejemplo, "/expertodb.vcrxol.com/Contabilidad/"). 
  //   window.location.protocol:  Devuelve el protocolo de la URL (por ejemplo, "https:"). 
  //   window.location.href:      Devuelve el URL de la pagina completa (por ejemplo: https://expertodb.vcrxol.com/Contabilidad/cgCatalogo.php )
  //   window.location.origin:    Devuelve el origen de la URL (protocolo + dominio) (ejemplo : https://expertodb.vcrxol.com ). 
  //   window.location.serch:     Devuelve los parametros enviados en el URL (ejemplo : ?keycli= 9999999999999 ). 

  return rdata;
}

function fnMuestraAnticpos() {
  xasync = true;
  var grTabla = "AnticipoCx";
  var msgalert, msgerror, msgsistemas;

  var lTipo = "";
  var lTiCo = "AN";
  var lCodi = document.getElementById('idPerso').value;
  var lFIni = document.getElementById('fchDesde').value;
  var lFFin = document.getElementById('fchHasta').value;

  var lOpcion = document.getElementById("selval");
  var opSele = lOpcion.value;



  var lNIni = 0;
  var lNFin = 0;

  var lEsta = "";
  var lEmis = "";
  var lFact = "";
  var lModu = document.getElementById('modulo').value;


  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: false,
    type: 'POST',
    data: {
      tablaGr: grTabla,
      Tipo: lTipo,
      Docu: lTiCo,
      idPerso: lCodi,
      Fini: lFIni,
      Ffin: lFFin,
      Nini: lNIni,
      Nfin: lNFin,
      Esta: lEsta,
      Emis: lEmis,
      Factu: lFact,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {

    },
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //    alert(dato);
      console.log(dato);
      document.getElementById("Listado").innerHTML = $(dato).find("TablaReporte").html();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Disculpe, existi� un problema');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Petici�n realizada');
    }
  })
  return rdata;
}

function fcnCancelFact() {
  xasync = false;
  var grTabla = "cccabecera";
  var msgalert, msgerror, msgsistemas;

  var lCodi = document.getElementById('idPerso').value;
  var lSecu = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Cliente: lCodi,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('pagos').innerHTML = $(dato).find("TablaCxC").html();

      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Facturas Pendientes');
    }
  })
  return rdata;

}

function fnGrabaPagoCxC2() {
  xasync = false;
  var grTabla = "PagoCx";
  var msgalert, msgerror, msgsistemas;
  var lTipo = document.getElementById('DocuPago').value;
  var lRefe = "";
  var lFech = document.getElementById('fechapago').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;
  var lCodi = document.getElementById('idPerso').value;
  var lNomb = document.getElementById('DCDescrip').value;
  var lValo = document.getElementById('TotalCxC').value;
  var lCtas = document.getElementById('DCuenta').value;
  var lIdCa = document.getElementById('IdCabe').value;
  var lDpto = document.getElementById('DDpto').value;
  var lArea = document.getElementById('DArea').value;
  var lModu = document.getElementById('modulo').value;

  var scrip = '../Libreria/libreria.php';

  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      tipo: lTipo,
      referen: lRefe,
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu,
      idPerso: lCodi,
      NomPer: lNomb,
      cuenta: lCtas,
      valor: lValo,
      idCabe: lIdCa,
      Dpto: lDpto,
      Area: lArea,
      Modulo: lModu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //alert(dato);
      console.log(dato);
      document.getElementById('numPago').value = $(dato).find("numdocu").text();
      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        var lcMsg = lcError.replace(/@/g, "\n");
        alert("Diccionario de Errores \n" + lcMsg);
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en Ingreso a Caja');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Docmuento Grabado');
    }
  })
  return rdata;
}

function fcnConsultaPago() {
  xasync = false;
  var grTabla = "consultacx";
  var msgalert, msgerror, msgsistemas;

  var lidCa = document.getElementById('IdCabe').value;
  var lModu = document.getElementById('modulo').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      transa: lidCa,
      modulo: lModu,
      tablaGr: grTabla
      //secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById("movimiento").innerHTML = $(dato).find("TablaReporte").html();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      alert('Facturas Pendientes');
    }
  })
  return rdata;

}

function exportTableToExcel(lTable, lFile) {
  var lArchivo = '';
  var lCta = '';
  var lMes = '';

  switch (lFile) {
    case '1':
      // Código a ejecutar si expresión === valor1
      lArchivo = 'Esta_Cuent';
      lCta = document.getElementById('CuentaD').value;
      break;
    case '2':
      // Código a ejecutar si expresión === valor1
      lArchivo = 'Situ_Finan';
      lCta = document.getElementById('Anio').value;
      break;
    case '3':
      // Código a ejecutar si expresión === valor1
      lArchivo = 'Esta_Resul';
      lCta = document.getElementById('Anio').value;
      lMes = document.getElementById('Mes').value;
      break;
    case '4':
      // Estado de Cuenta Bancario:
      lArchivo = 'Esta_Cuent';
      lCta = document.getElementById('Cuenta').value;
      lMes = document.getElementById('Hasta').value;
      break;
    default:
      // Código a ejecutar si ninguna de las anteriores coincide

  }

  lArchivo = lArchivo + '_' + lCta + '_' + lMes + '.xls';

  //let tabla = document.getElementById("EstaCta").outerHTML;
  let tabla = document.getElementById(lTable).outerHTML;
  let blob = new Blob(['\ufeff', tabla], {
    type: 'application/vnd.ms-excel'
  });
  let link = document.createElement('a');
  link.href = URL.createObjectURL(blob);
  //link.download = 'tabla.xls';
  link.download = lArchivo;
  link.click();
}

function fnGeneraCie() {
  xasync = false;
  var grTabla = "GeneraCie";
  var msgalert, msgerror, msgsistemas;

  var lFech = document.getElementById('fecha').value;
  var lDeta = document.getElementById('detalle').value;
  var lSecu = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      fecha: lFech,
      detalle: lDeta,
      tablaGr: grTabla,
      secuencia: lSecu
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      //console.log(dato);
      //alert(dato);
      //document.getElementById("detall").innerHTML = $(dato).find("TablaTest").html();

      var lcError = $(dato).find("DesError").text();
      if (lcError.length > 0) {
        fnsweetalert("Dicionario de Errores", lcError, "error", 1);
      } else {
        fnsweetalert("Proceso Terminado", "Diario Generado", "success", 2, "detall", $(dato).find("TablaTest").html());
      }
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Facturas Pendientes');
    }
  })
  return rdata;

}

function fnSecunFac() {

  xasync = false;
  var grTabla = "SecuFact";
  var msgalert, msgerror, msgsistemas;

  var lDocu = document.getElementById("documento").value;
  var lEsta = document.getElementById("estable").value;
  var lEmis = document.getElementById("emision").value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Docum: lDocu,
      Estable: lEsta,
      Emision: lEmis,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('secuencia').value = $(dato).find("SecuFact").text();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Facturas Pendientes');
    }
  })
  return rdata;
}

function fnValFact() {
  xasync = false;
  var grTabla = "DataFact";
  var msgalert, msgerror, msgsistemas;

  var lDocu = document.getElementById("documento").value;
  var lEsta = document.getElementById("festable").value;
  var lEmis = document.getElementById("femision").value;
  var lNume = document.getElementById("fsecuencia").value;

  lEsta = '000' + lEsta;
  lEmis = '000' + lEmis;
  lNume = '000000000' + lNume;

  document.getElementById('festable').value = lEsta.substr(-3);
  document.getElementById('femision').value = lEmis.substr(-3);
  document.getElementById('fsecuencia').value = lNume.substr(-9);

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      Docum: lDocu,
      Estable: lEsta,
      Emision: lEmis,
      Numero: lNume,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('idCliente').value = $(dato).find("idenClie").text();
      document.getElementById('DCDescrip').value = $(dato).find("nomClie").text();
      document.getElementById('fecha').value = $(dato).find("fecClie").text();
      document.getElementById('ValorFac').value = $(dato).find("valClie").text();
      document.getElementById('PagoFac').value = $(dato).find("pagClie").text();
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      alert('Error en cobro de deudas');
    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Facturas Pendientes');
    }
  })
  return rdata;
}

function fnGrabaDocXML() {
  xasync = false;
  var grTabla = "grabaXML";
  var msgalert, msgerror, msgsistemas;
  var lComp = document.getElementById('tipoCompro').value;
  var lSecu = document.getElementById('DSecuen').value;

  var scrip = '../Libreria/libreria.php';
  document.body.style.cursor = 'progress';
  var rdata;

  $.ajax({
    cache: false,
    url: scrip,
    datatype: "text",
    async: xasync,
    type: 'POST',
    data: {
      compro: lComp,
      secuen: lSecu,
      tablaGr: grTabla
    },
    beforeSend: function(jqXHR, textStatus) {},
    success: function(dato, textStatus, jqXHR) {
      document.body.style.cursor = 'default';
      console.log(dato);
      //alert(dato);
      document.getElementById('numCompro').value = $(dato).find("NumComp").text();
      fnsweetalert("Proceso Correcto", "Documento Grabado ", "success", 1);
      rdata = dato;
    },
    error: function(jqXHR, textStatus, errorThrown) {
      document.body.style.cursor = 'default';
      //alert('Error en cobro de deudas');
      fnsweetalert("Error en Grabacion", "Error en Documento XML ", "error", 1);

    },
    complete: function(jqXHR, status) {
      document.body.style.cursor = 'default';
      //alert('Facturas Pendientes');
    }
  })
  return rdata;
}