<?php
// Directorio raíz donde buscar archivos
// $directory = __DIR__; // Cambia esta ruta si es necesario
$directory = demo; // Cambia esta ruta si es necesario

// Función para buscar y corregir archivos PHP
function correctShortTags($dir) {
    $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($dir));
    
    foreach ($files as $file) {
        if ($file->isFile() && $file->getExtension() === 'php') {
            $filePath = $file->getRealPath();
            $content = file_get_contents($filePath);

            // Reemplazar "<?" al inicio con "<?php", evitando "<?=" (abreviatura de "echo")
            $updatedContent = preg_replace('/<\?(?!php|xml|=)/', '<?php', $content);

            if ($content !== $updatedContent) {
                file_put_contents($filePath, $updatedContent);
                echo "Corregido: $filePath\n";
            }
        }
    }
}

// Ejecutar la corrección
correctShortTags($directory);

echo "Proceso completado.\n";

?>
